/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import java.util.Collections;
import java.util.LinkedList;
import repast.simphony.space.grid.AbstractGrid;
import repast.simphony.space.grid.CellAccessor;
import repast.simphony.space.grid.GridAdder;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.grid.SimpleGridAdder;
import repast.simphony.space.grid.StrictBorders;

public class FastDenseSingleOccuGrid<T>
extends AbstractGrid<T, Object[]> {
    public FastDenseSingleOccuGrid(String name, GridAdder<T> adder, GridPointTranslator translator, int ... size) {
        super(name, adder, translator, new FastDenseAccessor(), size);
    }

    public FastDenseSingleOccuGrid(String name, int ... size) {
        super(name, new SimpleGridAdder(), (GridPointTranslator)new StrictBorders(), new FastDenseAccessor(), size);
    }

    @Override
    public Object[] createLocationStorage() {
        Object[] storage = new Object[this.dimensions.getDimension(0)];
        LinkedList<Object[]> prevLevel = new LinkedList<Object[]>();
        prevLevel.add(storage);
        int i = 1;
        while (i < this.dimensions.size()) {
            LinkedList<Object[]> prevLevelTemp = new LinkedList<Object[]>();
            int j = 0;
            while (prevLevel.size() > 0) {
                Object[] level = (Object[])prevLevel.remove();
                int k = 0;
                while (k < level.length) {
                    level[k] = new Object[this.dimensions.getDimension(i)];
                    prevLevelTemp.add((Object[])level[k]);
                    ++k;
                }
                ++j;
            }
            prevLevel = prevLevelTemp;
            ++i;
        }
        return storage;
    }

    public static final class FastDenseAccessor<V>
    implements CellAccessor<V, Object[]> {
        @Override
        public V get(Object[] locationStorage, GridPoint location) {
            int dims = location.dimensionCount();
            int i = 0;
            while (i < dims) {
                if (i != dims - 1) {
                    return (V)locationStorage[location.getCoord(i)];
                }
                locationStorage = (Object[])locationStorage[location.getCoord(i)];
                ++i;
            }
            return null;
        }

        @Override
        public Iterable<V> getAll(Object[] locationStorage, GridPoint location) {
            return Collections.singleton(this.get(locationStorage, location));
        }

        @Override
        public V getRandom(Object[] locationStorage, GridPoint location) {
            return this.get(locationStorage, location);
        }

        @Override
        public boolean put(V obj, Object[] locationStorage, GridPoint location) {
            int dims = location.dimensionCount();
            int i = 0;
            while (i < dims) {
                if (i == dims - 1) {
                    if (locationStorage[location.getCoord(i)] == null) {
                        locationStorage[location.getCoord((int)i)] = obj;
                        return true;
                    }
                    return false;
                }
                locationStorage = (Object[])locationStorage[location.getCoord(i)];
                ++i;
            }
            return false;
        }

        @Override
        public boolean allowsMultiOccupancy() {
            return false;
        }

        @Override
        public void remove(V obj, Object[] locationStorage, GridPoint location) {
            int dims = location.dimensionCount();
            int i = 0;
            while (i < dims) {
                if (i == dims - 1) {
                    locationStorage = (Object[])locationStorage[location.getCoord(i)];
                } else {
                    locationStorage[location.getCoord((int)i)] = null;
                }
                ++i;
            }
        }
    }
}

