/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import repast.simphony.space.grid.AbstractGridPointTranslator;
import repast.simphony.space.grid.GridDimensions;

public class BouncyBorders
extends AbstractGridPointTranslator {
    private transient BounceDimension[] bounceDimensions;

    public BouncyBorders() {
    }

    public BouncyBorders(int ... dimensions) {
        this.init(new GridDimensions(dimensions));
    }

    public BouncyBorders(int[] dimensions, int[] origin) {
        this.init(new GridDimensions(dimensions, origin));
    }

    @Override
    public void translate(int[] location, int ... displacement) {
        int i = 0;
        int[] nArray = displacement;
        int n = displacement.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            location[i] = this.bounceDimensions[i].translate(location[i], val);
            ++i;
            ++n2;
        }
    }

    @Override
    public void init(GridDimensions dimensions) {
        super.init(dimensions);
        this.bounceDimensions = new BounceDimension[dimensions.size()];
        int[] origin = dimensions.originToIntArray(null);
        int i = 0;
        while (i < dimensions.size()) {
            if (dimensions.getDimension(i) <= 0) {
                throw new IllegalArgumentException("Dimensions of space must be greater than 0");
            }
            this.bounceDimensions[i] = new BounceDimension(-origin[i], dimensions.getDimension(i) - origin[i] - 1);
            ++i;
        }
    }

    @Override
    public boolean isToroidal() {
        return false;
    }

    private static class BounceDimension {
        private int min;
        private int max;

        public BounceDimension(int min, int max) {
            this.max = max;
            this.min = min;
        }

        public int translate(int loc, int amt) {
            int newLoc = loc + amt;
            while (newLoc < this.min || newLoc > this.max) {
                newLoc = newLoc < this.min ? this.min + (this.min - newLoc) : this.max - (newLoc - this.max);
            }
            return newLoc;
        }
    }
}

