/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import repast.simphony.space.SpatialException;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.GridPointTranslator;

public abstract class AbstractGridPointTranslator
implements GridPointTranslator {
    protected transient GridDimensions dimensions;

    @Override
    public void init(GridDimensions dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public void transform(int[] transformedLocation, int ... targetLocation) throws SpatialException {
        int i = 0;
        while (i < targetLocation.length) {
            this.boundsCheck(i, targetLocation[i]);
            ++i;
        }
        i = 0;
        while (i < targetLocation.length) {
            transformedLocation[i] = targetLocation[i];
            ++i;
        }
    }

    protected void boundsCheck(int i, int value) {
        int[] origin = this.dimensions.originToIntArray(null);
        if (value < -origin[i] || value >= this.dimensions.getDimension(i) - origin[i]) {
            throw new SpatialException("Target location " + value + " is outside of grid's dimensions.");
        }
    }

    @Override
    public void transform(GridPoint transformedLocation, int ... targetLocation) throws SpatialException {
        this.transform(transformedLocation.point, targetLocation);
    }
}

