/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.space.SpatialException;
import repast.simphony.space.SpatialMath;
import repast.simphony.space.grid.CellAccessor;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridAdder;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.projection.DefaultProjection;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionPredicate;

public abstract class AbstractGrid<T, U>
extends DefaultProjection<T>
implements Grid<T> {
    private final List<T> EMPTY_LIST = new ArrayList<T>();
    private double[] vectorTmp;
    protected Map<T, PointHolder> agentLocationMap;
    protected U locationStorage;
    protected GridDimensions dimensions;
    protected GridAdder<T> adder;
    protected GridPointTranslator translator;
    protected CellAccessor<T, U> accessor;
    protected boolean ok = true;
    protected int size = 0;

    public AbstractGrid(String name, GridAdder<T> adder, GridPointTranslator translator, CellAccessor<T, U> accessor, int ... size) {
        super(name);
        this.adder = adder;
        this.translator = translator;
        this.accessor = accessor;
        int[] aSize = new int[size.length];
        int i = 0;
        int[] nArray = size;
        int n = size.length;
        int n2 = 0;
        while (n2 < n) {
            int dim = nArray[n2];
            aSize[i++] = dim;
            ++n2;
        }
        this.dimensions = new GridDimensions(aSize);
        this.vectorTmp = new double[this.dimensions.size()];
        this.agentLocationMap = new HashMap<T, PointHolder>();
        this.locationStorage = this.createLocationStorage();
        this.translator.init(this.dimensions);
    }

    public AbstractGrid(String name, GridAdder<T> adder, GridPointTranslator translator, CellAccessor<T, U> accessor, int[] size, int[] origin) {
        super(name);
        this.adder = adder;
        this.translator = translator;
        this.accessor = accessor;
        int[] aSize = new int[size.length];
        int i = 0;
        int[] nArray = size;
        int n = size.length;
        int n2 = 0;
        while (n2 < n) {
            int dim = nArray[n2];
            aSize[i++] = dim;
            ++n2;
        }
        this.dimensions = new GridDimensions(aSize, origin);
        this.vectorTmp = new double[this.dimensions.size()];
        this.agentLocationMap = new HashMap<T, PointHolder>();
        this.locationStorage = this.createLocationStorage();
        this.translator.init(this.dimensions);
    }

    protected abstract U createLocationStorage();

    @Override
    public boolean moveTo(T object, int ... newLocation) {
        PointHolder holder = this.agentLocationMap.get(object);
        if (holder == null) {
            throw new SpatialException("Object '" + object + "' must be added to the grid's context before it can be moved");
        }
        if (newLocation.length != this.dimensions.size()) {
            throw new SpatialException("Number of new location dimensions must match grid dimensions");
        }
        int[] movedCoords = new int[this.dimensions.size()];
        this.translator.transform(movedCoords, newLocation);
        return this.doMove(object, movedCoords, holder) != null;
    }

    private GridPoint doMove(T object, int[] movedCoords, PointHolder holder) {
        GridPoint movedPoint = new GridPoint(movedCoords);
        if (this.accessor.put(object, this.locationStorage, movedPoint)) {
            if (holder.point == null) {
                ++this.size;
            } else {
                this.accessor.remove(object, this.locationStorage, holder.point);
            }
            holder.point = movedPoint;
            this.fireProjectionEvent(new ProjectionEvent(this, object, ProjectionEvent.OBJECT_MOVED));
            return holder.point;
        }
        return null;
    }

    @Override
    public GridPoint getLocation(Object obj) {
        PointHolder loc = this.agentLocationMap.get(obj);
        if (loc == null) {
            return null;
        }
        return loc.point;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public GridPointTranslator getGridPointTranslator() {
        return this.translator;
    }

    @Override
    public void setGridPointTranslator(GridPointTranslator rule) {
        this.translator = rule;
    }

    @Override
    public Iterable<T> getObjects() {
        return this.agentLocationMap.keySet();
    }

    @Override
    public T getObjectAt(int ... location) {
        int[] loc = this.getTransformedLocation(location);
        if (loc == null) {
            return null;
        }
        return this.accessor.get(this.locationStorage, new GridPoint(loc));
    }

    @Override
    public Iterable<T> getObjectsAt(int ... location) {
        int[] loc = this.getTransformedLocation(location);
        if (loc == null) {
            return this.EMPTY_LIST;
        }
        return this.accessor.getAll(this.locationStorage, new GridPoint(loc));
    }

    protected int[] getTransformedLocation(int ... location) {
        int[] loc = new int[location.length];
        this.translator.transform(loc, location);
        return loc;
    }

    @Override
    public T getRandomObjectAt(int ... location) {
        int[] loc = this.getTransformedLocation(location);
        if (loc == null) {
            return null;
        }
        return this.accessor.getRandom(this.locationStorage, new GridPoint(loc));
    }

    @Override
    public GridPoint moveByDisplacement(T object, int ... displacement) {
        if (this.dimensions.size() < displacement.length) {
            throw new SpatialException("Displacement matrix cannot have more dimensions than space");
        }
        PointHolder holder = this.agentLocationMap.get(object);
        if (holder == null) {
            throw new SpatialException("Object '" + object + "' must be added to the space's context before it can be moved");
        }
        int[] movedCoords = new int[this.dimensions.size()];
        holder.point.toIntArray(movedCoords);
        this.translator.translate(movedCoords, displacement);
        return this.doMove(object, movedCoords, holder);
    }

    @Override
    public GridPoint moveByVector(T object, double distance, double ... anglesInRadians) {
        int length;
        int size = this.dimensions.size();
        if (size < (length = anglesInRadians.length)) {
            throw new SpatialException("Number of angles must be less than or equal to the number of dimensions");
        }
        if (length < size) {
            int i = 0;
            while (i < this.vectorTmp.length) {
                this.vectorTmp[i] = 0.0;
                ++i;
            }
            i = 0;
            while (i < length) {
                this.vectorTmp[i] = anglesInRadians[i];
                ++i;
            }
            return this.moveByDisplacement(object, SpatialMath.getDisplacementInt(size, 0, distance, this.vectorTmp));
        }
        return this.moveByDisplacement(object, SpatialMath.getDisplacementInt(size, 0, distance, anglesInRadians));
    }

    @Override
    public GridDimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public void setAdder(GridAdder<T> adder) {
        this.adder = adder;
    }

    @Override
    public GridAdder<T> getAdder() {
        return this.adder;
    }

    @Override
    public CellAccessor getCellAccessor() {
        return this.accessor;
    }

    protected void removeAll() {
        for (T t : this.agentLocationMap.keySet()) {
            this.remove(t);
        }
    }

    protected void remove(T t) {
        GridPoint location = this.agentLocationMap.remove(t).point;
        if (location != null) {
            this.accessor.remove(t, this.locationStorage, location);
            --this.size;
            this.fireProjectionEvent(new ProjectionEvent(this, t, ProjectionEvent.OBJECT_REMOVED));
        }
    }

    @Override
    public boolean isPeriodic() {
        return this.translator.isToroidal();
    }

    @Override
    public boolean evaluate(ProjectionPredicate predicate) {
        return predicate.evaluate(this);
    }

    @Override
    public double getDistance(GridPoint point1, GridPoint point2) {
        double distanceSq = this.getDistanceSq(point1, point2);
        return Double.isNaN(distanceSq) ? distanceSq : Math.sqrt(distanceSq);
    }

    @Override
    public double getDistanceSq(GridPoint point1, GridPoint point2) {
        if (point1.dimensionCount() != point2.dimensionCount()) {
            return Double.NaN;
        }
        double sum = 0.0;
        int i = 0;
        int n = point1.point.length;
        while (i < n) {
            double diff = point1.point[i] - point2.point[i];
            if (this.isPeriodic()) {
                int dim = this.getDimensions().getDimension(i);
                double absDiff = Math.abs(diff);
                if (absDiff > (double)(dim / 2)) {
                    diff = (double)dim - absDiff;
                }
            }
            sum += diff * diff;
            ++i;
        }
        return sum;
    }

    public static class PointHolder {
        GridPoint point;
    }
}

