/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.graph;

import edu.uci.ics.jung.graph.UndirectedOrderedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import repast.simphony.space.graph.DefaultEdgeCreator;
import repast.simphony.space.graph.EdgeCreator;
import repast.simphony.space.graph.JungNetwork;
import repast.simphony.space.graph.RepastEdge;

public class UndirectedJungNetwork<T>
extends JungNetwork<T> {
    public UndirectedJungNetwork(String name) {
        this(name, new DefaultEdgeCreator());
    }

    public UndirectedJungNetwork(String name, EdgeCreator<? extends RepastEdge<T>, T> creator) {
        super(name, creator);
        this.graph = new UndirectedOrderedSparseMultigraph();
    }

    @Override
    public RepastEdge<T> addEdge(RepastEdge<T> edge) {
        edge.setDirected(false);
        return super.addEdge(edge, EdgeType.UNDIRECTED);
    }

    @Override
    public RepastEdge<T> addEdge(T source, T target, double weight) {
        Object edge = this.creator.createEdge(source, target, false, weight);
        this.addEdge((RepastEdge<T>)edge);
        return edge;
    }

    @Override
    public int getDegree(T agent) {
        return this.graph.getIncidentEdges(agent).size();
    }

    @Override
    public int getInDegree(T agent) {
        return this.getDegree(agent);
    }

    @Override
    public int getOutDegree(T agent) {
        return this.getDegree(agent);
    }

    @Override
    public boolean isDirected() {
        return false;
    }
}

