/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.graph;

import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.Graph;
import java.util.List;
import org.apache.commons.collections15.Transformer;
import repast.simphony.context.space.graph.ContextJungNetwork;
import repast.simphony.space.graph.JungEdgeTransformer;
import repast.simphony.space.graph.JungNetwork;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;

public class ShortestPath<T>
implements ProjectionListener<T> {
    private Network<T> net;
    private boolean calc = true;
    private T source;
    private JungEdgeTransformer transformer;
    private DijkstraShortestPath<T, RepastEdge<T>> dsp;

    public ShortestPath() {
    }

    public ShortestPath(Network<T> net) {
        this.init(net);
    }

    @Deprecated
    public ShortestPath(Network<T> net, T source) {
        this.source = source;
        this.init(net);
    }

    private void init(Network<T> net) {
        this.net = net;
        this.transformer = new JungEdgeTransformer();
        net.addProjectionListener(this);
    }

    public List<RepastEdge<T>> getPath(T source, T target) {
        if (this.calc) {
            this.calcPaths();
            this.calc = false;
        }
        return this.dsp.getPath(source, target);
    }

    public double getPathLength(T source, T target) {
        Number n;
        if (this.calc) {
            this.calcPaths();
            this.calc = false;
        }
        if ((n = this.dsp.getDistance(source, target)) != null) {
            return n.doubleValue();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Deprecated
    public double getPathLength(T target) {
        return this.getPathLength(this.source, target);
    }

    private void calcPaths() {
        Graph graph = null;
        if (this.net instanceof JungNetwork) {
            graph = ((JungNetwork)this.net).getGraph();
        } else if (this.net instanceof ContextJungNetwork) {
            graph = ((ContextJungNetwork)this.net).getGraph();
        }
        this.dsp = new DijkstraShortestPath(graph, (Transformer)this.transformer);
    }

    @Override
    public void projectionEventOccurred(ProjectionEvent<T> evt) {
        if (evt.getType() != ProjectionEvent.OBJECT_MOVED) {
            this.calc = true;
        }
    }

    public void finalize() {
        if (this.net != null) {
            this.net.removeProjectionListener(this);
        }
    }

    public static ShortestPath finished(ShortestPath<?> sp) {
        sp.finalize();
        sp = null;
        return sp;
    }
}

