/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.graph;

import edu.uci.ics.jung.graph.Graph;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import repast.simphony.space.graph.RepastEdge;
import simphony.util.messages.MessageCenter;

public class ORANetWriter {
    private static MessageCenter LOG = MessageCenter.getMessageCenter(ORANetWriter.class);

    public void save(String title, Graph network, String fileName) {
        try {
            File file = new File(fileName);
            String xmlFileName = file.getAbsolutePath();
            PrintWriter writer = new PrintWriter(file);
            writer.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
            writer.println("");
            writer.println("<DynamicNetwork>");
            writer.println("    <MetaNetwork id=\"Meta Network\">");
            writer.println("        <documents></documents>");
            writer.println("        <nodes>");
            writer.println("            <nodeclass type=\"Agent\" id=\"Agent\">");
            HashMap idMap = new HashMap();
            for (Object obj : network.getVertices()) {
                String name = obj.toString();
                if (name == null || name.equals("")) {
                    name = obj.getClass().getName();
                }
                String qualifiedName = name.replace("\"", "");
                int counter = 1;
                while (idMap.get(qualifiedName) != null) {
                    qualifiedName = (String.valueOf(name) + counter).replace("\"", "");
                    ++counter;
                }
                idMap.put(obj, qualifiedName);
                writer.println("                <node id=\"" + qualifiedName + "\">");
                boolean wrotePropertyTag = false;
                Method[] methodArray = obj.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    String methodName = method.getName();
                    if (!(method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0 || methodName.equals("toString") || methodName.equals("getMetaClass") || methodName.equals("hashCode") || methodName.equals("getClass"))) {
                        try {
                            Object methodResult = method.invoke(obj, new Object[0]);
                            if (methodName.startsWith("get")) {
                                methodName = methodName.substring(3);
                            }
                            if (!wrotePropertyTag) {
                                writer.println("                    <properties>");
                            }
                            writer.println("                        <property name=\"" + methodName + "\" type=\"String\" value=\"" + methodResult + "\"/>");
                            wrotePropertyTag = true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                if (wrotePropertyTag) {
                    writer.println("                    </properties>");
                }
                writer.println("</node>");
            }
            writer.println("            </nodeclass>");
            writer.println("        </nodes>");
            writer.println("        <networks>");
            writer.println("            <network sourceType=\"Agent\" source=\"Agent\" targetType=\"Agent\" target=\"Agent\" id=\"" + title.replace(" ", "") + "\">");
            for (Object obj : network.getEdges()) {
                if (!(obj instanceof RepastEdge)) continue;
                RepastEdge edge = (RepastEdge)obj;
                Object src = edge.getSource();
                Object tar = edge.getTarget();
                String srcName = (String)idMap.get(src);
                String tarName = (String)idMap.get(tar);
                double weight = edge.getWeight();
                writer.println("                <link source=\"" + srcName + "\" target=\"" + tarName + "\" type=\"double\" value=\"" + weight + "\"></link>");
            }
            writer.println("            </network>");
            writer.println("        </networks>");
            writer.println("    </MetaNetwork>");
            writer.println("</DynamicNetwork>");
            writer.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("ORA export file \"" + fileName + "\" could not be written: "), (Throwable)e, new Object[0]);
        }
    }
}

