/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import repast.simphony.random.RandomHelper;
import repast.simphony.space.graph.DefaultEdgeCreator;
import repast.simphony.space.graph.EdgeCreator;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.projection.DefaultProjection;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionPredicate;

public abstract class JungNetwork<T>
extends DefaultProjection<T>
implements Network<T> {
    protected Graph<T, RepastEdge<T>> graph;
    private ArrayList<T> tmpRandomList = new ArrayList();
    protected EdgeCreator<? extends RepastEdge<T>, T> creator;

    public JungNetwork(String name) {
        this(name, new DefaultEdgeCreator());
    }

    public JungNetwork(String name, EdgeCreator<? extends RepastEdge<T>, T> creator) {
        super(name);
        this.creator = creator;
    }

    @Override
    public EdgeCreator<? extends RepastEdge<T>, T> getEdgeCreator() {
        return this.creator;
    }

    public void setGraph(Graph<T, RepastEdge<T>> graph) {
        this.graph = graph;
    }

    public Graph<T, RepastEdge<T>> getGraph() {
        return this.graph;
    }

    @Override
    public boolean evaluate(ProjectionPredicate predicate) {
        return predicate.evaluate(this);
    }

    @Override
    public Iterable<T> getAdjacent(T agent) {
        LinkedHashSet out = new LinkedHashSet();
        out.addAll(this.graph.getPredecessors(agent));
        out.addAll(this.graph.getSuccessors(agent));
        return out;
    }

    @Override
    public int getDegree() {
        return this.graph.getEdges().size();
    }

    @Override
    public int getDegree(T agent) {
        return this.graph.degree(agent);
    }

    @Override
    public Iterable<RepastEdge<T>> getEdges() {
        return this.graph.getEdges();
    }

    @Override
    public Iterable<RepastEdge<T>> getEdges(T agent) {
        return this.graph.getIncidentEdges(agent);
    }

    @Override
    public int getInDegree(T agent) {
        return this.graph.inDegree(agent);
    }

    @Override
    public Iterable<RepastEdge<T>> getInEdges(T agent) {
        return this.graph.getInEdges(agent);
    }

    @Override
    public Iterable<T> getNodes() {
        return this.graph.getVertices();
    }

    @Override
    public int getOutDegree(T agent) {
        return this.graph.outDegree(agent);
    }

    @Override
    public Iterable<RepastEdge<T>> getOutEdges(T agent) {
        return this.graph.getOutEdges(agent);
    }

    @Override
    public Iterable<T> getPredecessors(T agent) {
        return this.graph.getPredecessors(agent);
    }

    @Override
    public T getRandomAdjacent(T agent) {
        int size = this.graph.getNeighbors(agent).size();
        if (size == 0) {
            return null;
        }
        int index = RandomHelper.getUniform().nextIntFromTo(0, size - 1);
        this.tmpRandomList.clear();
        this.tmpRandomList.addAll(this.graph.getNeighbors(agent));
        return this.tmpRandomList.get(index);
    }

    @Override
    public T getRandomPredecessor(T agent) {
        int size = this.graph.getPredecessors(agent).size();
        if (size == 0) {
            return null;
        }
        int index = RandomHelper.getUniform().nextIntFromTo(0, size - 1);
        this.tmpRandomList.clear();
        this.tmpRandomList.addAll(this.graph.getPredecessors(agent));
        return this.tmpRandomList.get(index);
    }

    @Override
    public T getRandomSuccessor(T agent) {
        int size = this.graph.getSuccessors(agent).size();
        if (size == 0) {
            return null;
        }
        int index = RandomHelper.getUniform().nextIntFromTo(0, size - 1);
        this.tmpRandomList.clear();
        this.tmpRandomList.addAll(this.graph.getSuccessors(agent));
        return this.tmpRandomList.get(index);
    }

    @Override
    public Iterable<T> getSuccessors(T agent) {
        return this.graph.getSuccessors(agent);
    }

    @Override
    public boolean isAdjacent(T first, T second) {
        return this.graph.isNeighbor(first, second) || this.graph.isNeighbor(second, first);
    }

    @Override
    public boolean isPredecessor(T first, T second) {
        return this.graph.isPredecessor(second, first);
    }

    @Override
    public boolean isSuccessor(T first, T second) {
        return this.graph.isSuccessor(second, first);
    }

    @Override
    public int numEdges() {
        return this.graph.getEdges().size();
    }

    @Override
    public void removeEdge(RepastEdge<T> edge) {
        if (this.graph.removeEdge(edge)) {
            this.fireProjectionEvent(new ProjectionEvent(this, edge, ProjectionEvent.EDGE_REMOVED));
        }
    }

    @Override
    public boolean containsEdge(RepastEdge<T> edge) {
        return this.graph.containsEdge(edge);
    }

    @Override
    public RepastEdge<T> addEdge(RepastEdge<T> edge) {
        RepastEdge oldEdge = (RepastEdge)this.graph.findEdge(edge.getSource(), edge.getTarget());
        if (oldEdge != null) {
            this.removeEdge(oldEdge);
        }
        this.graph.addEdge(edge, edge.getSource(), edge.getTarget());
        this.fireProjectionEvent(new ProjectionEvent(this, edge, ProjectionEvent.EDGE_ADDED));
        return edge;
    }

    @Override
    public RepastEdge<T> addEdge(RepastEdge<T> edge, EdgeType type) {
        RepastEdge oldEdge = (RepastEdge)this.graph.findEdge(edge.getSource(), edge.getTarget());
        if (oldEdge != null) {
            this.removeEdge(oldEdge);
        }
        this.graph.addEdge(edge, edge.getSource(), edge.getTarget(), type);
        this.fireProjectionEvent(new ProjectionEvent(this, edge, ProjectionEvent.EDGE_ADDED));
        return edge;
    }

    @Override
    public RepastEdge<T> addEdge(T source, T target) {
        return this.addEdge(source, target, 1.0);
    }

    @Override
    public RepastEdge<T> getEdge(T source, T target) {
        return (RepastEdge)this.graph.findEdge(source, target);
    }

    @Override
    public int size() {
        return this.graph.getVertices().size();
    }

    public void addVertex(T vertex) {
        this.graph.addVertex(vertex);
        this.fireProjectionEvent(new ProjectionEvent(this, vertex, ProjectionEvent.OBJECT_ADDED));
    }

    public void removeVertex(T vertex) {
        Collection edges = this.graph.getIncidentEdges(vertex);
        ArrayList<RepastEdge> tempEdges = new ArrayList<RepastEdge>();
        for (RepastEdge edge : edges) {
            tempEdges.add(edge);
        }
        this.graph.removeVertex(vertex);
        this.fireProjectionEvent(new ProjectionEvent(this, vertex, ProjectionEvent.OBJECT_REMOVED));
        for (RepastEdge edge : tempEdges) {
            this.fireProjectionEvent(new ProjectionEvent(this, edge, ProjectionEvent.EDGE_REMOVED));
        }
    }

    @Override
    public void removeEdges() {
        Iterator<RepastEdge<T>> ie = this.getEdges().iterator();
        while (ie.hasNext()) {
            this.removeEdge(ie.next());
            ie = this.getEdges().iterator();
        }
    }
}

