/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.delaunay;

import repast.simphony.space.delaunay.QuadEdge;

public class TriangulationPoint {
    private static final long serialVersionUID = 3258416131596695094L;
    double x;
    double y;
    boolean isInf = false;
    public Object contents;

    public TriangulationPoint(double x, double y, Object contents) {
        this.x = x;
        this.y = y;
        this.contents = contents;
    }

    public Object getContents() {
        return this.contents;
    }

    public boolean isOn(QuadEdge e) {
        TriangulationPoint pte;
        TriangulationPoint pts = e.getOrg();
        return this.Area(pts, this, pte = e.getDest()) == 0.0;
    }

    public boolean isRightOf(QuadEdge e) {
        TriangulationPoint pte;
        TriangulationPoint pts = e.getOrg();
        return this.Area(this, pts, pte = e.getDest()) > 0.0;
    }

    public boolean isLeftOf(QuadEdge e) {
        TriangulationPoint pte;
        TriangulationPoint pts = e.getOrg();
        return this.Area(this, pts, pte = e.getDest()) < 0.0;
    }

    private double Area(TriangulationPoint p1, TriangulationPoint p2, TriangulationPoint p3) {
        return (p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y);
    }

    public boolean isInCircle(TriangulationPoint p1, TriangulationPoint p2, TriangulationPoint p3) {
        long x2 = (long)p2.x;
        long x1 = (long)p1.x;
        long y3 = (long)p3.y;
        long y1 = (long)p1.y;
        long x4 = (long)this.x;
        long y4 = (long)this.y;
        long x3 = (long)p3.x;
        long y2 = (long)p2.y;
        long a = (x2 - x1) * (y3 - y1) * (x4 * x4 + y4 * y4 - x1 * x1 - y1 * y1) + (x3 - x1) * (y4 - y1) * (x2 * x2 + y2 * y2 - x1 * x1 - y1 * y1) + (x4 - x1) * (y2 - y1) * (x3 * x3 + y3 * y3 - x1 * x1 - y1 * y1) - (x2 - x1) * (y4 - y1) * (x3 * x3 + y3 * y3 - x1 * x1 - y1 * y1) - (x3 - x1) * (y2 - y1) * (x4 * x4 + y4 * y4 - x1 * x1 - y1 * y1) - (x4 - x1) * (y3 - y1) * (x2 * x2 + y2 * y2 - x1 * x1 - y1 * y1);
        return a > 0L;
    }

    public double getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }
}

