/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.delaunay;

import java.awt.Color;
import java.awt.Graphics;
import repast.simphony.space.delaunay.DelaunayGraph;
import repast.simphony.space.delaunay.QuadEdge;
import repast.simphony.space.delaunay.TriangulationPoint;

public class IrregularGridRenderer {
    public void drawPoint(TriangulationPoint p, Graphics g, Color clPoint) {
        g.setColor(clPoint);
        g.fillOval((int)p.getX() - 3, (int)p.getY() - 3, 6, 6);
    }

    public void drawGraph(DelaunayGraph graph, Graphics g, Color dcl, Color vcl, Color hcl, boolean drawD, boolean drawV, boolean drawH) {
        QuadEdge e;
        int i;
        if (drawD || drawH) {
            i = 0;
            while (i < graph.edges.size()) {
                e = graph.edges.get(i);
                g.setColor(dcl);
                if (e.isValidEdge()) {
                    if (e.getLNext().isValidEdge() && e.getRNext().isValidEdge()) {
                        if (drawD) {
                            g.drawLine((int)e.getOrg().x, (int)e.getOrg().y, (int)e.getDest().x, (int)e.getDest().y);
                        }
                    } else {
                        if (drawH) {
                            g.setColor(hcl);
                        }
                        g.drawLine((int)e.getOrg().x, (int)e.getOrg().y, (int)e.getDest().x, (int)e.getDest().y);
                    }
                }
                i += 4;
            }
        }
        if (drawV) {
            graph.getVoronoiDiagram();
            g.setColor(vcl);
            i = 1;
            while (i < graph.edges.size()) {
                e = graph.edges.get(i);
                if (e.isValidEdge()) {
                    g.drawLine((int)e.getOrg().x, (int)e.getOrg().y, (int)e.getDest().x, (int)e.getDest().y);
                }
                i += 4;
            }
        }
    }
}

