/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.delaunay;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import repast.simphony.space.delaunay.DelaunayGraph;
import repast.simphony.space.delaunay.IrregularGridRenderer;

class DrawingArea
extends JPanel {
    private static final long serialVersionUID = 3256723961659405622L;
    DelaunayGraph graph;
    IrregularGridRenderer rend;

    public DrawingArea() {
        this.initialize();
        this.rend = new IrregularGridRenderer();
    }

    public DrawingArea(DelaunayGraph graph) {
        this.graph = graph;
        this.initialize();
        this.rend = new IrregularGridRenderer();
    }

    void initialize() {
        this.setBackground(Color.WHITE);
        if (this.graph == null) {
            this.graph = new DelaunayGraph();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int x = this.getSize().width;
        int y = this.getSize().height;
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, x, y);
        this.rend.drawGraph(this.graph, g, Color.blue, Color.RED, new Color(0, 192, 64), false, true, false);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(500, 500);
        frame.setDefaultCloseOperation(3);
        DelaunayGraph graph = null;
        DrawingArea da = new DrawingArea(graph);
        frame.getContentPane().add(da);
        frame.setVisible(true);
    }
}

