/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.delaunay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.space.delaunay.QuadEdge;
import repast.simphony.space.delaunay.TriangulationPoint;

public class DelaunayGraph {
    private static final long serialVersionUID = 3258416131596695094L;
    private Map<Object, TriangulationPoint> nodeMap;
    List<QuadEdge> edges = new ArrayList<QuadEdge>();

    public DelaunayGraph() {
        this.init();
    }

    public void init() {
        this.nodeMap = new HashMap<Object, TriangulationPoint>();
        QuadEdge e1 = this.makeQEdge();
        QuadEdge e2 = this.makeQEdge();
        QuadEdge e3 = this.makeQEdge();
        e1.setOrg(new TriangulationPoint(0.0, -8192.0, null));
        e2.setOrg(new TriangulationPoint(-16384.0, 8192.0, null));
        e3.setOrg(new TriangulationPoint(16384.0, 8192.0, null));
        e1.setDest(e2.getOrg());
        e1.getOrg().isInf = true;
        e2.setDest(e3.getOrg());
        e2.getOrg().isInf = true;
        e3.setDest(e1.getOrg());
        e3.getOrg().isInf = true;
        e1.setONext(e3.getSym());
        e1.getRot().setONext(e2.getRot());
        e1.getSym().setONext(e2);
        e1.getRot3().setONext(e2.getRot3());
        e2.setONext(e1.getSym());
        e2.getRot().setONext(e3.getRot());
        e2.getSym().setONext(e3);
        e2.getRot3().setONext(e3.getRot3());
        e3.setONext(e2.getSym());
        e3.getRot().setONext(e1.getRot());
        e3.getSym().setONext(e1);
        e3.getRot3().setONext(e1.getRot3());
    }

    public QuadEdge connect(QuadEdge a, QuadEdge b) {
        QuadEdge e = this.makeQEdge();
        e.setOrg(a.getDest());
        e.setDest(b.getOrg());
        this.splice(e, a.getLNext());
        this.splice(e.getSym(), b);
        return e;
    }

    public void deleteEdge(QuadEdge e) {
        this.splice(e, e.getOPrev());
        this.splice(e.getSym(), e.getSym().getOPrev());
        int i = 0;
        while (i < 3) {
            QuadEdge eRot = e.getRot();
            this.edges.remove(e);
            e = eRot;
            ++i;
        }
        this.edges.remove(e);
    }

    public void swap(QuadEdge e) {
        QuadEdge a = e.getOPrev();
        QuadEdge b = e.getSym().getOPrev();
        this.splice(e, a);
        this.splice(e.getSym(), b);
        this.splice(e, a.getLNext());
        this.splice(e.getSym(), b.getLNext());
        e.setOrg(a.getDest());
        e.setDest(b.getDest());
    }

    public TriangulationPoint getPoint(Object node) {
        return this.nodeMap.get(node);
    }

    public void insertSite(TriangulationPoint X, Object node) {
        QuadEdge e;
        if (node != null) {
            this.nodeMap.put(node, X);
        }
        if (X.isOn(e = this.locate(X))) {
            QuadEdge t = e.getOPrev();
            this.deleteEdge(e);
            e = t;
        }
        QuadEdge newEdge = this.makeQEdge();
        TriangulationPoint StartPnt = e.getOrg();
        newEdge.setOrg(StartPnt);
        newEdge.setDest(X);
        this.splice(newEdge, e);
        while ((e = (newEdge = this.connect(e, newEdge.getSym())).getOPrev()).getDest() != StartPnt) {
        }
        while (true) {
            QuadEdge t = e.getOPrev();
            boolean passTest = X.isInCircle(e.getOrg(), t.getDest(), e.getDest());
            if (t.getDest().isRightOf(e) && passTest) {
                this.swap(e);
                e = e.getOPrev();
                continue;
            }
            if (e.getOrg() == StartPnt) {
                return;
            }
            e = e.getONext().getLPrev();
        }
    }

    public QuadEdge locate(TriangulationPoint X) {
        QuadEdge e = this.edges.get(0);
        while (true) {
            if (X == e.getOrg() || X == e.getDest()) {
                return e;
            }
            if (X.isRightOf(e)) {
                e = e.getSym();
                continue;
            }
            if (!X.isRightOf(e.oNext)) {
                e = e.oNext;
                continue;
            }
            if (X.isRightOf(e.getDPrev())) break;
            e = e.getDPrev();
        }
        return e;
    }

    public void getVoronoiDiagram() {
        int i = 12;
        while (i < this.edges.size()) {
            QuadEdge e = this.edges.get(i);
            if (e.isValidEdge()) {
                TriangulationPoint pl = this.getVoronoiVertex(e, e.getONext());
                TriangulationPoint pr = this.getVoronoiVertex(e, e.getOPrev());
                e.rot.setOrg(pr);
                e.rot.setDest(pl);
            }
            i += 4;
        }
    }

    private TriangulationPoint getVoronoiVertex(QuadEdge e1, QuadEdge e2) {
        TriangulationPoint pnt = new TriangulationPoint(0.0, 0.0, null);
        long x2 = (long)e1.getOrg().x;
        long y2 = (long)e1.getOrg().y;
        long x1 = (long)e1.getDest().x;
        long y1 = (long)e1.getDest().y;
        long x3 = (long)e2.getDest().x;
        long y3 = (long)e2.getDest().y;
        long det = (y2 - y3) * (x2 - x1) - (y2 - y1) * (x2 - x3);
        long c1 = (x1 + x2) * (x2 - x1) / 2L + (y2 - y1) * (y1 + y2) / 2L;
        long c2 = (x2 + x3) * (x2 - x3) / 2L + (y2 - y3) * (y2 + y3) / 2L;
        pnt.x = (int)((c1 * (y2 - y3) - c2 * (y2 - y1)) / det);
        pnt.y = (int)((c2 * (x2 - x1) - c1 * (x2 - x3)) / det);
        pnt.isInf = false;
        return pnt;
    }

    public QuadEdge makeQEdge() {
        QuadEdge[] e = new QuadEdge[4];
        int i = 0;
        while (i < 4) {
            e[i] = new QuadEdge();
            ++i;
        }
        e[0].setRot(e[1]);
        e[1].setRot(e[2]);
        e[2].setRot(e[3]);
        e[3].setRot(e[0]);
        e[0].setONext(e[0]);
        e[1].setONext(e[3]);
        e[2].setONext(e[2]);
        e[3].setONext(e[1]);
        i = 0;
        while (i < 4) {
            this.edges.add(e[i]);
            ++i;
        }
        return e[0];
    }

    public void splice(QuadEdge a, QuadEdge b) {
        QuadEdge aa = a.getONext().getRot();
        QuadEdge bb = b.getONext().getRot();
        QuadEdge tmp = a.getONext();
        a.setONext(b.getONext());
        b.setONext(tmp);
        tmp = aa.getONext();
        aa.setONext(bb.getONext());
        bb.setONext(tmp);
    }
}

