/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.continuous;

import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.AbstractPointTranslator;
import repast.simphony.space.continuous.NdPoint;

public class WrapAroundBorders
extends AbstractPointTranslator {
    protected transient double[] spaceWidths;
    protected transient double[] origin;
    protected transient boolean newLocationWrapped;

    public boolean isNewLocationWrapped() {
        return this.newLocationWrapped;
    }

    public void setNewLocationWrapped(boolean newCoordinateWrapped) {
        this.newLocationWrapped = newCoordinateWrapped;
    }

    @Override
    public void init(Dimensions dimensions) {
        super.init(dimensions);
        this.spaceWidths = dimensions.toDoubleArray(null);
        this.origin = dimensions.originToDoubleArray(null);
        this.newLocationWrapped = false;
    }

    @Override
    public void translate(double[] location, double ... displacement) {
        this.setNewLocationWrapped(false);
        int i = 0;
        while (i < displacement.length) {
            location[i] = this.getNewCoord(i, location[i] + displacement[i]);
            ++i;
        }
    }

    @Override
    public void translate(NdPoint location, double[] newLocation, double ... displacement) {
        this.setNewLocationWrapped(false);
        int i = 0;
        while (i < displacement.length) {
            newLocation[i] = this.getNewCoord(i, location.point[i] + displacement[i]);
            ++i;
        }
    }

    @Override
    public void transform(double[] transformedLocation, double ... targetLocation) {
        this.setNewLocationWrapped(false);
        int i = 0;
        while (i < targetLocation.length) {
            transformedLocation[i] = this.getNewCoord(i, targetLocation[i]);
            ++i;
        }
    }

    @Override
    public void transform(NdPoint transformedLocation, double ... targetLocation) {
        this.transform(transformedLocation.point, targetLocation);
    }

    protected double getNewCoord(int dimension, double location) {
        double shiftedLocation = location + this.origin[dimension];
        double value = shiftedLocation % this.spaceWidths[dimension];
        if (value < 0.0) {
            value = this.spaceWidths[dimension] + value;
        }
        if (value != shiftedLocation) {
            this.setNewLocationWrapped(true);
        }
        return value - this.origin[dimension];
    }

    @Override
    public boolean isPeriodic() {
        return true;
    }
}

