/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.continuous;

import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.AbstractPointTranslator;
import repast.simphony.space.continuous.NdPoint;

public class StickyBorders
extends AbstractPointTranslator {
    private transient double[][] spaceMinsMaxes;
    private static final int MIN = 0;
    private static final int MAX = 1;

    @Override
    public void init(Dimensions dimensions) {
        super.init(dimensions);
        this.spaceMinsMaxes = new double[2][dimensions.size()];
        double[] origin = dimensions.originToDoubleArray(null);
        int i = 0;
        while (i < dimensions.size()) {
            double min = -origin[i];
            if (-min == 0.0) {
                min = 0.0;
            }
            this.spaceMinsMaxes[0][i] = min;
            this.spaceMinsMaxes[1][i] = dimensions.getDimension(i) - origin[i];
            ++i;
        }
    }

    protected double getNewCoord(int dimension, double coord) {
        if (coord < this.spaceMinsMaxes[0][dimension]) {
            return this.spaceMinsMaxes[0][dimension];
        }
        if (coord >= this.spaceMinsMaxes[1][dimension]) {
            return StickyBorders.minusEpsilon(this.spaceMinsMaxes[1][dimension]);
        }
        return coord;
    }

    @Override
    public void translate(double[] location, double ... displacement) {
        int i = 0;
        while (i < displacement.length) {
            location[i] = this.getNewCoord(i, location[i] + displacement[i]);
            ++i;
        }
    }

    @Override
    public void translate(NdPoint location, double[] newLocation, double ... displacement) {
        int i = 0;
        while (i < displacement.length) {
            newLocation[i] = this.getNewCoord(i, location.point[i] + displacement[i]);
            ++i;
        }
    }

    @Override
    public boolean isPeriodic() {
        return false;
    }
}

