/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.continuous;

import repast.simphony.random.RandomHelper;
import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.ContinuousAdder;
import repast.simphony.space.continuous.ContinuousSpace;

public class RandomCartesianAdder<T>
implements ContinuousAdder<T> {
    @Override
    public void add(ContinuousSpace<T> space, T obj) {
        Dimensions dims = space.getDimensions();
        double[] location = new double[dims.size()];
        this.findLocation(location, dims);
        while (!space.moveTo(obj, location)) {
            this.findLocation(location, dims);
        }
    }

    private void findLocation(double[] location, Dimensions dims) {
        double[] origin = dims.originToDoubleArray(null);
        int i = 0;
        while (i < location.length) {
            try {
                location[i] = RandomHelper.getUniform().nextDoubleFromTo(0.0, dims.getDimension(i)) - origin[i];
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }
}

