/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.continuous;

import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.AbstractPointTranslator;
import repast.simphony.space.continuous.NdPoint;

public class BouncyBorders
extends AbstractPointTranslator {
    private transient Dimension[] dimensions;

    public BouncyBorders() {
    }

    public BouncyBorders(double ... dimensions) {
        this.init(new Dimensions(dimensions));
    }

    public BouncyBorders(double[] dimensions, double[] origin) {
        this.init(new Dimensions(dimensions, origin));
    }

    @Override
    public void translate(NdPoint location, double[] newLocation, double ... displacement) {
        double[] point = location.point;
        int i = 0;
        double[] dArray = displacement;
        int n = displacement.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            newLocation[i] = this.dimensions[i].translate(point[i], val);
            ++i;
            ++n2;
        }
    }

    @Override
    public void translate(double[] location, double ... displacement) {
        int i = 0;
        double[] dArray = displacement;
        int n = displacement.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            location[i] = this.dimensions[i].translate(location[i], val);
            ++i;
            ++n2;
        }
    }

    @Override
    public void init(Dimensions dimensions) {
        super.init(dimensions);
        this.dimensions = new Dimension[dimensions.size()];
        double[] origin = dimensions.originToDoubleArray(null);
        int i = 0;
        while (i < dimensions.size()) {
            if (dimensions.getDimension(i) <= 0.0) {
                throw new IllegalArgumentException("Dimensions of space must be greater than 0");
            }
            double min = -origin[i];
            if (-min == 0.0) {
                min = 0.0;
            }
            this.dimensions[i] = new Dimension(min, dimensions.getDimension(i) - origin[i]);
            ++i;
        }
    }

    @Override
    public boolean isPeriodic() {
        return false;
    }

    private static class Dimension {
        private double min;
        private double max;

        public Dimension(double min, double max) {
            this.max = max;
            this.min = min;
        }

        public double translate(double loc, double amt) {
            double newLoc = loc + amt;
            while (newLoc < this.min || newLoc >= this.max) {
                newLoc = newLoc < this.min ? this.min + (this.min - newLoc) : (newLoc > this.max ? this.max - (newLoc - this.max) : BouncyBorders.minusEpsilon(newLoc));
            }
            return newLoc;
        }
    }
}

