/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.continuous;

import repast.simphony.space.Dimensions;
import repast.simphony.space.SpatialException;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.continuous.PointTranslator;

public abstract class AbstractPointTranslator
implements PointTranslator {
    protected transient Dimensions dimensions;

    @Override
    public void init(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public void transform(double[] transformedLocation, double ... targetLocation) throws SpatialException {
        int i = 0;
        while (i < targetLocation.length) {
            this.boundsCheck(i, targetLocation[i]);
            ++i;
        }
        i = 0;
        while (i < targetLocation.length) {
            transformedLocation[i] = targetLocation[i];
            ++i;
        }
    }

    protected void boundsCheck(int i, double value) {
        double[] origin = this.dimensions.originToDoubleArray(null);
        if (value < -origin[i] || value >= this.dimensions.getDimension(i) - origin[i]) {
            throw new SpatialException("Target location " + value + " is outside of grid's dimensions.");
        }
    }

    @Override
    public void transform(NdPoint transformedLocation, double ... targetLocation) throws SpatialException {
        this.transform(transformedLocation.point, targetLocation);
    }

    protected static double minusEpsilon(double amount) {
        double result = 0.0;
        double b = 10.0;
        int i = 1;
        while (amount - Math.pow(amount, -((double)i)) != amount) {
            ++i;
        }
        return amount - Math.pow(amount, -((double)(i - 1)));
    }
}

