/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.continuous;

import java.util.HashMap;
import java.util.Map;
import repast.simphony.random.RandomHelper;
import repast.simphony.space.Dimensions;
import repast.simphony.space.SpatialMath;
import repast.simphony.space.continuous.ContinuousAdder;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.CoordinateAccessor;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.continuous.PointTranslator;
import repast.simphony.space.projection.DefaultProjection;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionPredicate;

public abstract class AbstractContinuousSpace<T, U>
extends DefaultProjection<T>
implements ContinuousSpace<T> {
    protected Map<T, PointHolder> agentLocationMap;
    protected U locationStorage;
    protected Dimensions dimensions;
    protected ContinuousAdder<T> adder;
    protected PointTranslator translator;
    protected CoordinateAccessor<T, U> accessor;
    protected int size = 0;

    public AbstractContinuousSpace(String name, ContinuousAdder<T> adder, PointTranslator translator, CoordinateAccessor<T, U> accessor, double ... size) {
        super(name);
        this.adder = adder;
        this.translator = translator;
        this.accessor = accessor;
        int _size = 1;
        double[] aSize = new double[size.length];
        int i = 0;
        double[] dArray = size;
        int n = size.length;
        int n2 = 0;
        while (n2 < n) {
            double dim = dArray[n2];
            _size = (int)((double)_size * dim);
            aSize[i++] = dim;
            ++n2;
        }
        this.dimensions = new Dimensions(aSize);
        this.agentLocationMap = new HashMap<T, PointHolder>();
        this.locationStorage = this.createLocationStorage();
        this.translator.init(this.dimensions);
    }

    public AbstractContinuousSpace(String name, ContinuousAdder<T> adder, PointTranslator translator, CoordinateAccessor<T, U> accessor, double[] size, double[] origin) {
        super(name);
        this.adder = adder;
        this.translator = translator;
        this.accessor = accessor;
        this.dimensions = new Dimensions(size, origin);
        this.agentLocationMap = new HashMap<T, PointHolder>();
        this.locationStorage = this.createLocationStorage();
        this.translator.init(this.dimensions);
    }

    protected abstract U createLocationStorage();

    @Override
    public boolean moveTo(T object, double ... newLocation) {
        return this.doMove(object, null, newLocation);
    }

    protected boolean doMove(T object, double[] displacement, double[] newLocation) {
        PointHolder holder = this.agentLocationMap.get(object);
        if (holder == null) {
            throw new IllegalArgumentException("Object '" + object + "' must be added to the space's context before it can be moved");
        }
        if (newLocation != null && newLocation.length != this.dimensions.size()) {
            throw new IllegalArgumentException("An object's new location must have the same number of dimensions as the space. (newLocation's dimensions: " + newLocation.length + ", space's:" + this.dimensions.size() + ".");
        }
        double[] movedCoords = new double[this.dimensions.size()];
        if (holder.point == null || displacement == null) {
            this.translator.transform(movedCoords, newLocation);
        } else {
            holder.point.toDoubleArray(movedCoords);
            this.translator.translate(movedCoords, displacement);
        }
        NdPoint movedPoint = new NdPoint(movedCoords);
        if (this.accessor.put(object, this.locationStorage, movedPoint)) {
            if (holder.point != null) {
                this.accessor.remove(object, this.locationStorage, holder.point);
            } else {
                ++this.size;
            }
            holder.point = movedPoint;
            this.fireProjectionEvent(new ProjectionEvent(this, object, ProjectionEvent.OBJECT_MOVED));
            return true;
        }
        return false;
    }

    @Override
    public NdPoint getLocation(Object obj) {
        PointHolder holder = this.agentLocationMap.get(obj);
        if (holder == null) {
            return null;
        }
        return holder.point;
    }

    @Override
    public int size() {
        return this.agentLocationMap.size();
    }

    @Override
    public PointTranslator getPointTranslator() {
        return this.translator;
    }

    @Override
    public void setPointTranslator(PointTranslator rule) {
        this.translator = rule;
    }

    @Override
    public Iterable<T> getObjects() {
        return this.agentLocationMap.keySet();
    }

    @Override
    public T getObjectAt(double ... location) {
        return this.accessor.get(this.locationStorage, new NdPoint(this.getLocation(location)));
    }

    @Override
    public Iterable<T> getObjectsAt(double ... location) {
        return this.accessor.getAll(this.locationStorage, new NdPoint(this.getLocation(location)));
    }

    protected double[] getLocation(double ... location) {
        double[] loc = new double[location.length];
        this.translator.transform(loc, location);
        return loc;
    }

    @Override
    public T getRandomObjectAt(double ... location) {
        return this.accessor.getRandom(RandomHelper.getUniform(), this.locationStorage, new NdPoint(this.getLocation(location)));
    }

    @Override
    public NdPoint moveByDisplacement(T object, double ... displacement) {
        if (this.dimensions.size() < displacement.length) {
            throw new IllegalArgumentException("Displacement matrix cannot have more dimensions than space");
        }
        if (this.doMove(object, displacement, null)) {
            return this.agentLocationMap.get(object).point;
        }
        return null;
    }

    @Override
    public NdPoint moveByVector(T object, double distance, double ... anglesInRadians) {
        if (this.dimensions.size() != anglesInRadians.length) {
            throw new IllegalArgumentException("Displacement matrix has different number of dimensions than space");
        }
        return this.moveByDisplacement(object, SpatialMath.getDisplacement(this.dimensions.size(), 0, distance, anglesInRadians));
    }

    @Override
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public void setAdder(ContinuousAdder<T> adder) {
        this.adder = adder;
    }

    @Override
    public ContinuousAdder<T> getAdder() {
        return this.adder;
    }

    protected void removeAll() {
        for (T t : this.agentLocationMap.keySet()) {
            this.remove(t);
        }
    }

    protected void remove(T t) {
        NdPoint location = this.agentLocationMap.remove(t).point;
        if (location != null) {
            this.accessor.remove(t, this.locationStorage, location);
        }
        --this.size;
        this.fireProjectionEvent(new ProjectionEvent(this, t, ProjectionEvent.OBJECT_REMOVED));
    }

    @Override
    public boolean isPeriodic() {
        return this.translator.isPeriodic();
    }

    @Override
    public boolean evaluate(ProjectionPredicate predicate) {
        return predicate.evaluate(this);
    }

    @Override
    public double getDistance(NdPoint point1, NdPoint point2) {
        double distanceSq = this.getDistanceSq(point1, point2);
        return Double.isNaN(distanceSq) ? distanceSq : Math.sqrt(distanceSq);
    }

    @Override
    public double getDistanceSq(NdPoint point1, NdPoint point2) {
        if (point1.dimensionCount() != point2.dimensionCount()) {
            return Double.NaN;
        }
        double sum = 0.0;
        int i = 0;
        int n = point1.dimensionCount();
        while (i < n) {
            double diff = point1.getCoord(i) - point2.getCoord(i);
            if (this.isPeriodic()) {
                double dim = this.getDimensions().getDimension(i);
                double absDiff = Math.abs(diff);
                if (absDiff > dim / 2.0) {
                    diff = dim - absDiff;
                }
            }
            sum += diff * diff;
            ++i;
        }
        return sum;
    }

    @Override
    public double[] getDisplacement(NdPoint point1, NdPoint point2) {
        if (point1.dimensionCount() != point2.dimensionCount()) {
            return null;
        }
        double[] displacement = new double[point1.dimensionCount()];
        int i = 0;
        int n = point1.dimensionCount();
        while (i < n) {
            double diff = point2.getCoord(i) - point1.getCoord(i);
            if (this.isPeriodic()) {
                double dim = this.getDimensions().getDimension(i);
                double absDiff = Math.abs(diff);
                if (absDiff > dim / 2.0) {
                    diff = -Math.signum(diff) * (dim - absDiff);
                }
            }
            displacement[i] = diff;
            ++i;
        }
        return displacement;
    }

    public static class PointHolder {
        public NdPoint point;
    }
}

