/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space;

import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;

public class SpatialMath {
    private static double[] rotate(double[] plane, double angle) {
        double x = plane[0];
        double y = plane[1];
        plane[0] = x * Math.cos(angle) - y * Math.sin(angle);
        plane[1] = y * Math.cos(angle) + x * Math.sin(angle);
        return plane;
    }

    public static void scale(double[] point, double scale) {
        int i = 0;
        while (i < point.length) {
            point[i] = point[i] * scale;
            ++i;
        }
    }

    public static double[] getDisplacement(int dimCount, int unitDimension, double scale, double ... anglesInRadians) {
        double[] displacement = new double[dimCount];
        displacement[unitDimension] = 1.0;
        double[] tmp = new double[2];
        int c = 0;
        int i = 0;
        while (i < dimCount) {
            if (i != unitDimension) {
                if (i > unitDimension) {
                    tmp[0] = displacement[unitDimension];
                    tmp[1] = displacement[i];
                    SpatialMath.rotate(tmp, anglesInRadians[c]);
                    displacement[unitDimension] = tmp[0];
                    displacement[i] = tmp[1];
                } else if (i < unitDimension) {
                    tmp[0] = displacement[i];
                    tmp[1] = displacement[unitDimension];
                    SpatialMath.rotate(tmp, anglesInRadians[c]);
                    displacement[unitDimension] = tmp[1];
                    displacement[i] = tmp[0];
                }
                ++c;
            }
            ++i;
        }
        SpatialMath.scale(displacement, scale);
        return displacement;
    }

    public static int[] getDisplacementInt(int dimCount, int unitDimension, double scale, double ... anglesInRadians) {
        double[] displacement = SpatialMath.getDisplacement(dimCount, unitDimension, scale, anglesInRadians);
        int[] intDisplacement = new int[dimCount];
        int i = 0;
        while (i < dimCount) {
            intDisplacement[i] = (int)Math.rint(displacement[i]);
            ++i;
        }
        return intDisplacement;
    }

    public static double angleFromDisplacement(double dX, double dY) {
        return Math.atan2(dY, dX);
    }

    public static double calcAngleFor2DMovement(ContinuousSpace<? extends Object> space, NdPoint point1, NdPoint point2) {
        double[] displacement = space.getDisplacement(point1, point2);
        return SpatialMath.angleFromDisplacement(displacement[0], displacement[1]);
    }
}

