/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space;

import java.util.Arrays;
import simphony.util.messages.MessageCenter;

public class Dimensions {
    double[] dimensions;
    private int hashCode;
    double[] origin;

    public Dimensions(int ... dimensions) {
        this.dimensions = new double[dimensions.length];
        this.origin = new double[dimensions.length];
        int i = 0;
        while (i < dimensions.length) {
            this.dimensions[i] = dimensions[i];
            ++i;
        }
        this.init();
    }

    public Dimensions(int[] dimensions, int[] origin) {
        this.dimensions = new double[dimensions.length];
        this.origin = new double[dimensions.length];
        int i = 0;
        while (i < dimensions.length) {
            this.dimensions[i] = dimensions[i];
            this.origin[i] = origin[i];
            ++i;
        }
        this.init();
    }

    public Dimensions(double ... dimensions) {
        this.dimensions = dimensions;
        this.origin = new double[dimensions.length];
        this.init();
    }

    public Dimensions(double[] dimensions, double[] origin) {
        this.dimensions = dimensions;
        this.origin = origin;
        this.init();
    }

    public Dimensions(double[] dimensions, int[] origin) {
        this.dimensions = dimensions;
        this.origin = new double[dimensions.length];
        int i = 0;
        while (i < dimensions.length) {
            this.origin[i] = origin[i];
            ++i;
        }
        this.init();
    }

    private void init() {
        if (this.dimensions == null) {
            return;
        }
        this.hashCode = 17;
        double[] dArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            long l = Double.doubleToLongBits(val);
            if (l <= 0L) {
                MessageCenter.getMessageCenter(Dimensions.class).warn((Object)l, new Object[]{"Under normal circumstances, a dimension value should not be set to a value of zero or less."});
            }
            int hash = (int)(l ^ l >>> 32);
            this.hashCode = 37 * this.hashCode + hash;
            ++n2;
        }
    }

    public double getWidth() {
        return this.dimensions[0];
    }

    public double getHeight() {
        return this.dimensions[1];
    }

    public double getDepth() {
        return this.dimensions[2];
    }

    public double getDimension(int index) {
        return this.dimensions[index];
    }

    public double getOrigin(int index) {
        return this.origin[index];
    }

    public int size() {
        return this.dimensions.length;
    }

    public int[] toIntArray(int[] array) {
        if (array == null) {
            array = new int[this.dimensions.length];
        }
        int i = 0;
        while (i < this.dimensions.length) {
            array[i] = (int)this.dimensions[i];
            ++i;
        }
        return array;
    }

    public double[] toDoubleArray(double[] array) {
        if (array == null) {
            array = new double[this.dimensions.length];
        }
        int i = 0;
        while (i < this.dimensions.length) {
            array[i] = this.dimensions[i];
            ++i;
        }
        return array;
    }

    public double[] originToDoubleArray(double[] array) {
        if (array == null) {
            array = new double[this.origin.length];
        }
        int i = 0;
        while (i < this.origin.length) {
            array[i] = this.origin[i];
            ++i;
        }
        return array;
    }

    public int[] originToIntArray(int[] array) {
        if (array == null) {
            array = new int[this.origin.length];
        }
        int i = 0;
        while (i < this.origin.length) {
            array[i] = (int)this.origin[i];
            ++i;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.dimensions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Dimensions)) {
            return false;
        }
        Dimensions other = (Dimensions)obj;
        if (other.dimensions.length != this.dimensions.length) {
            return false;
        }
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i] != other.dimensions[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

