/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.random;

import cern.jet.random.AbstractDistribution;
import cern.jet.random.Beta;
import cern.jet.random.Binomial;
import cern.jet.random.BreitWigner;
import cern.jet.random.BreitWignerMeanSquare;
import cern.jet.random.ChiSquare;
import cern.jet.random.Empirical;
import cern.jet.random.EmpiricalWalker;
import cern.jet.random.Exponential;
import cern.jet.random.ExponentialPower;
import cern.jet.random.Gamma;
import cern.jet.random.HyperGeometric;
import cern.jet.random.Hyperbolic;
import cern.jet.random.Logarithmic;
import cern.jet.random.NegativeBinomial;
import cern.jet.random.Normal;
import cern.jet.random.Poisson;
import cern.jet.random.PoissonSlow;
import cern.jet.random.StudentT;
import cern.jet.random.Uniform;
import cern.jet.random.VonMises;
import cern.jet.random.Zeta;
import cern.jet.random.engine.RandomEngine;
import repast.simphony.random.DefaultRandomRegistry;
import repast.simphony.random.RandomRegistry;
import simphony.util.messages.MessageCenter;

public class RandomHelper {
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(RandomHelper.class);
    private static DefaultRandomRegistry defaultRegistry = new DefaultRandomRegistry();

    static {
        RandomHelper.init();
    }

    public static Beta createBeta(double alpha, double beta) {
        return defaultRegistry.createBeta(alpha, beta);
    }

    public static Binomial createBinomial(int n, double p) {
        return defaultRegistry.createBinomial(n, p);
    }

    public static BreitWigner createBreitWigner(double mean, double gamma, double cut) {
        return defaultRegistry.createBreitWigner(mean, gamma, cut);
    }

    public static BreitWignerMeanSquare createBreitWignerMeanSquare(double mean, double gamma, double cut) {
        return defaultRegistry.createBreitWignerMeanSquareState(mean, gamma, cut);
    }

    public static ChiSquare createChiSquare(double freedom) {
        return defaultRegistry.createChiSquare(freedom);
    }

    public static Empirical createEmpirical(double[] pdf, int interpolationType) {
        return defaultRegistry.createEmpirical(pdf, interpolationType);
    }

    public static EmpiricalWalker createEmpiricalWalker(double[] pdf, int interpolationType) {
        return defaultRegistry.createEmpiricalWalker(pdf, interpolationType);
    }

    public static Exponential createExponential(double lambda) {
        return defaultRegistry.createExponential(lambda);
    }

    public static ExponentialPower createExponentialPower(double tau) {
        return defaultRegistry.createExponentialPower(tau);
    }

    public static Gamma createGamma(double alpha, double lambda) {
        return defaultRegistry.createGamma(alpha, lambda);
    }

    public static Hyperbolic createHyperbolic(double alpha, double beta) {
        return defaultRegistry.createHyperbolic(alpha, beta);
    }

    public static HyperGeometric createHyperGeometric(int N, int s, int n) {
        return defaultRegistry.createHyperGeometric(N, s, n);
    }

    public static Logarithmic createLogarithmic(double p) {
        return defaultRegistry.createLogarithmic(p);
    }

    public static NegativeBinomial createNegativeBinomial(int n, double p) {
        return defaultRegistry.createNegativeBinomial(n, p);
    }

    public static Normal createNormal(double mean, double standardDeviation) {
        return defaultRegistry.createNormal(mean, standardDeviation);
    }

    public static Poisson createPoisson(double mean) {
        return defaultRegistry.createPoisson(mean);
    }

    public static PoissonSlow createPoissonSlow(double mean) {
        return defaultRegistry.createPoissonSlow(mean);
    }

    public static StudentT createStudentT(double freedom) {
        return defaultRegistry.createStudentT(freedom);
    }

    public static Uniform createUniform() {
        return defaultRegistry.createUniform();
    }

    public static Uniform createUniform(double min, double max) {
        return defaultRegistry.createUniform(min, max);
    }

    public static VonMises createVonMises(double freedom) {
        return defaultRegistry.createVonMises(freedom);
    }

    public static Zeta createZeta(double ro, double pk) {
        return defaultRegistry.createZeta(ro, pk);
    }

    public static Beta getBeta() {
        return defaultRegistry.getBeta();
    }

    public static Binomial getBinomial() {
        return defaultRegistry.getBinomial();
    }

    public static BreitWigner getBreitWigner() {
        return defaultRegistry.getBreitWigner();
    }

    public static BreitWignerMeanSquare getBreitWignerMeanSquare() {
        return defaultRegistry.getBreitWignerMeanSquare();
    }

    public static ChiSquare getChiSquare() {
        return defaultRegistry.getChiSquare();
    }

    public static Empirical getEmpirical() {
        return defaultRegistry.getEmpirical();
    }

    public static EmpiricalWalker getEmpiricalWalker() {
        return defaultRegistry.getEmpiricalWalker();
    }

    public static Exponential getExponential() {
        return defaultRegistry.getExponential();
    }

    public static ExponentialPower getExponentialPower() {
        return defaultRegistry.getExponentialPower();
    }

    public static Gamma getGamma() {
        return defaultRegistry.getGamma();
    }

    public static Hyperbolic getHyperbolic() {
        return defaultRegistry.getHyperbolic();
    }

    public static HyperGeometric getHyperGeometric() {
        return defaultRegistry.getHyperGeometric();
    }

    public static Logarithmic getLogarithmic() {
        return defaultRegistry.getLogarithmic();
    }

    public static NegativeBinomial getNegativeBinomial() {
        return defaultRegistry.getNegativeBinomial();
    }

    public static Normal getNormal() {
        return defaultRegistry.getNormal();
    }

    public static Poisson getPoisson() {
        return defaultRegistry.getPoisson();
    }

    public static PoissonSlow getPoissonSlow() {
        return defaultRegistry.getPoissonSlow();
    }

    public static StudentT getStudentT() {
        return defaultRegistry.getStudentT();
    }

    public static Uniform getUniform() {
        return defaultRegistry.getUniform();
    }

    public static VonMises getVonMises() {
        return defaultRegistry.getVonMises();
    }

    public static Zeta getZeta() {
        return defaultRegistry.getZeta();
    }

    public static void setSeed(int seed) {
        defaultRegistry.setSeed(seed);
        RandomHelper.createUniform();
    }

    public static double nextDoubleFromTo(double from, double to) {
        return RandomHelper.getUniform().nextDoubleFromTo(from, to);
    }

    public static double nextDouble() {
        return RandomHelper.getUniform().nextDouble();
    }

    public static int nextIntFromTo(int from, int to) {
        return RandomHelper.getUniform().nextIntFromTo(from, to);
    }

    public static int nextInt() {
        return RandomHelper.getUniform().nextInt();
    }

    public static void init() {
        defaultRegistry = new DefaultRandomRegistry();
        RandomHelper.setSeed((int)System.currentTimeMillis());
        RandomHelper.createUniform();
    }

    public static RandomRegistry getDefaultRegistry() {
        return defaultRegistry;
    }

    public static RandomEngine getGenerator() {
        return defaultRegistry.getGenerator(RandomRegistry.DEFAULT_GENERATOR);
    }

    public static int getSeed() {
        return defaultRegistry.getSeed(RandomRegistry.DEFAULT_GENERATOR);
    }

    public static RandomEngine registerGenerator(String name, int seed) {
        return defaultRegistry.registerGenerator(name, seed);
    }

    public static RandomEngine getGenerator(String generatorName) {
        return defaultRegistry.getGenerator(generatorName);
    }

    public static int getSeed(String generatorName) {
        return defaultRegistry.getSeed(generatorName);
    }

    public static void registerDistribution(String name, AbstractDistribution dist) {
        defaultRegistry.registerDistribution(name, dist);
    }

    public static AbstractDistribution getDistribution(String name) {
        return defaultRegistry.getDistribution(name);
    }
}

