/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.random;

import cern.jet.random.AbstractDistribution;
import cern.jet.random.Beta;
import cern.jet.random.Binomial;
import cern.jet.random.BreitWigner;
import cern.jet.random.BreitWignerMeanSquare;
import cern.jet.random.ChiSquare;
import cern.jet.random.Empirical;
import cern.jet.random.EmpiricalWalker;
import cern.jet.random.Exponential;
import cern.jet.random.ExponentialPower;
import cern.jet.random.Gamma;
import cern.jet.random.HyperGeometric;
import cern.jet.random.Hyperbolic;
import cern.jet.random.Logarithmic;
import cern.jet.random.NegativeBinomial;
import cern.jet.random.Normal;
import cern.jet.random.Poisson;
import cern.jet.random.PoissonSlow;
import cern.jet.random.StudentT;
import cern.jet.random.Uniform;
import cern.jet.random.VonMises;
import cern.jet.random.Zeta;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import java.util.HashMap;
import java.util.Map;
import repast.simphony.random.RandomRegistry;
import simphony.util.messages.MessageCenter;

public class DefaultRandomRegistry
implements RandomRegistry {
    private static final MessageCenter log = MessageCenter.getMessageCenter(DefaultRandomRegistry.class);
    protected int defaultSeed;
    private RandomEngine generator;
    private Map<String, GeneratorInfo> generators = new HashMap<String, GeneratorInfo>();
    private Map<String, AbstractDistribution> nonDefaultDistributions = new HashMap<String, AbstractDistribution>();
    private Beta beta;
    private Binomial binomial;
    private BreitWigner breitWigner;
    private BreitWignerMeanSquare breitWignerMeanSquare;
    private ChiSquare chiSquare;
    private Empirical empirical;
    private EmpiricalWalker empiricalWalker;
    private Exponential exponential;
    private ExponentialPower exponentialPower;
    private Gamma gamma;
    private Hyperbolic hyperbolic;
    private HyperGeometric hyperGeometric;
    private Logarithmic logarithmic;
    private NegativeBinomial negativeBinomial;
    private Normal normal;
    private Poisson poisson;
    private PoissonSlow poissonSlow;
    private StudentT studentT;
    private Uniform uniform;
    private VonMises vonMises;
    private Zeta zeta;
    private Map<Thread, Uniform> uniformValues = new HashMap<Thread, Uniform>();

    public DefaultRandomRegistry() {
        this.generator = this.registerGenerator(DEFAULT_GENERATOR, (int)System.currentTimeMillis());
    }

    @Override
    public RandomEngine registerGenerator(String name, int seed) {
        MersenneTwister engine = new MersenneTwister(seed);
        this.generators.put(name, new GeneratorInfo((RandomEngine)engine, seed));
        return engine;
    }

    @Override
    public RandomEngine getGenerator(String generatorName) {
        return this.generators.get(generatorName).generator;
    }

    @Override
    public int getSeed(String generatorName) {
        return this.generators.get(generatorName).seed;
    }

    @Override
    public void registerDistribution(String name, AbstractDistribution dist) {
        this.nonDefaultDistributions.put(name, dist);
    }

    @Override
    public AbstractDistribution getDistribution(String name) {
        return this.nonDefaultDistributions.get(name);
    }

    @Override
    public Zeta createZeta(double ro, double pk) {
        this.zeta = new Zeta(ro, pk, this.generator);
        return this.zeta;
    }

    @Override
    public Zeta getZeta() {
        return this.zeta;
    }

    @Override
    public VonMises createVonMises(double freedom) {
        this.vonMises = new VonMises(freedom, this.generator);
        return this.vonMises;
    }

    @Override
    public Uniform createUniform(double min, double max) {
        this.uniform = new Uniform(min, max, this.generator);
        return this.uniform;
    }

    @Override
    public Uniform createUniform() {
        this.uniform = new Uniform(this.generator);
        return this.uniform;
    }

    @Override
    public StudentT createStudentT(double freedom) {
        this.studentT = new StudentT(freedom, this.generator);
        return this.studentT;
    }

    @Override
    public PoissonSlow createPoissonSlow(double mean) {
        this.poissonSlow = new PoissonSlow(mean, this.generator);
        return this.poissonSlow;
    }

    @Override
    public Poisson createPoisson(double mean) {
        this.poisson = new Poisson(mean, this.generator);
        return this.poisson;
    }

    @Override
    public Normal createNormal(double mean, double standardDeviation) {
        this.normal = new Normal(mean, standardDeviation, this.generator);
        return this.normal;
    }

    @Override
    public NegativeBinomial createNegativeBinomial(int n, double p) {
        this.negativeBinomial = new NegativeBinomial(n, p, this.generator);
        return this.negativeBinomial;
    }

    @Override
    public Logarithmic createLogarithmic(double p) {
        this.logarithmic = new Logarithmic(p, this.generator);
        return this.logarithmic;
    }

    @Override
    public HyperGeometric createHyperGeometric(int N, int s, int n) {
        this.hyperGeometric = new HyperGeometric(N, s, n, this.generator);
        return this.hyperGeometric;
    }

    @Override
    public Hyperbolic createHyperbolic(double alpha, double beta) {
        this.hyperbolic = new Hyperbolic(alpha, beta, this.generator);
        return this.hyperbolic;
    }

    @Override
    public Gamma createGamma(double alpha, double lambda) {
        this.gamma = new Gamma(alpha, lambda, this.generator);
        return this.gamma;
    }

    @Override
    public ExponentialPower createExponentialPower(double tau) {
        this.exponentialPower = new ExponentialPower(tau, this.generator);
        return this.exponentialPower;
    }

    @Override
    public Exponential createExponential(double lambda) {
        this.exponential = new Exponential(lambda, this.generator);
        return this.exponential;
    }

    @Override
    public EmpiricalWalker createEmpiricalWalker(double[] pdf, int interpolationType) {
        this.empiricalWalker = new EmpiricalWalker(pdf, interpolationType, this.generator);
        return this.empiricalWalker;
    }

    @Override
    public Empirical createEmpirical(double[] pdf, int interpolationType) {
        this.empirical = new Empirical(pdf, interpolationType, this.generator);
        return this.empirical;
    }

    @Override
    public ChiSquare createChiSquare(double freedom) {
        this.chiSquare = new ChiSquare(freedom, this.generator);
        return this.chiSquare;
    }

    @Override
    public BreitWignerMeanSquare createBreitWignerMeanSquareState(double mean, double gamma, double cut) {
        this.breitWignerMeanSquare = new BreitWignerMeanSquare(mean, gamma, cut, this.generator);
        return this.breitWignerMeanSquare;
    }

    @Override
    public BreitWigner createBreitWigner(double mean, double gamma, double cut) {
        this.breitWigner = new BreitWigner(mean, gamma, cut, this.generator);
        return this.breitWigner;
    }

    @Override
    public Binomial createBinomial(int n, double p) {
        this.binomial = new Binomial(n, p, this.generator);
        return this.binomial;
    }

    @Override
    public Beta createBeta(double alpha, double beta) {
        this.beta = new Beta(alpha, beta, this.generator);
        return this.beta;
    }

    @Override
    public Beta getBeta() {
        return this.beta;
    }

    @Override
    public Binomial getBinomial() {
        return this.binomial;
    }

    @Override
    public BreitWigner getBreitWigner() {
        return this.breitWigner;
    }

    @Override
    public BreitWignerMeanSquare getBreitWignerMeanSquare() {
        return this.breitWignerMeanSquare;
    }

    @Override
    public ChiSquare getChiSquare() {
        return this.chiSquare;
    }

    @Override
    public Empirical getEmpirical() {
        return this.empirical;
    }

    @Override
    public EmpiricalWalker getEmpiricalWalker() {
        return this.empiricalWalker;
    }

    @Override
    public Exponential getExponential() {
        return this.exponential;
    }

    @Override
    public ExponentialPower getExponentialPower() {
        return this.exponentialPower;
    }

    @Override
    public Gamma getGamma() {
        return this.gamma;
    }

    @Override
    public Hyperbolic getHyperbolic() {
        return this.hyperbolic;
    }

    @Override
    public HyperGeometric getHyperGeometric() {
        return this.hyperGeometric;
    }

    @Override
    public Logarithmic getLogarithmic() {
        return this.logarithmic;
    }

    @Override
    public NegativeBinomial getNegativeBinomial() {
        return this.negativeBinomial;
    }

    @Override
    public Normal getNormal() {
        return this.normal;
    }

    @Override
    public Poisson getPoisson() {
        return this.poisson;
    }

    @Override
    public PoissonSlow getPoissonSlow() {
        return this.poissonSlow;
    }

    @Override
    public StudentT getStudentT() {
        return this.studentT;
    }

    @Override
    public Uniform getUniform() {
        if (this.uniform == null) {
            this.uniform = this.createUniform();
        }
        return this.uniform;
    }

    @Override
    public VonMises getVonMises() {
        return this.vonMises;
    }

    @Override
    public void setSeed(int seed) {
        this.invalidateDefaultDistributions();
        this.generator = this.registerGenerator(DEFAULT_GENERATOR, seed);
    }

    private void invalidateDefaultDistributions() {
        this.beta = null;
        this.binomial = null;
        this.breitWigner = null;
        this.breitWignerMeanSquare = null;
        this.chiSquare = null;
        this.empirical = null;
        this.empiricalWalker = null;
        this.exponential = null;
        this.exponentialPower = null;
        this.gamma = null;
        this.hyperbolic = null;
        this.hyperGeometric = null;
        this.logarithmic = null;
        this.negativeBinomial = null;
        this.normal = null;
        this.poisson = null;
        this.poissonSlow = null;
        this.studentT = null;
        this.uniform = null;
        this.vonMises = null;
        this.zeta = null;
    }

    @Override
    public void reset() {
        this.invalidateDefaultDistributions();
        this.nonDefaultDistributions.clear();
        this.generators.clear();
        this.setSeed((int)System.currentTimeMillis());
        this.createUniform();
    }

    private static class GeneratorInfo {
        private RandomEngine generator;
        private int seed;

        public GeneratorInfo(RandomEngine generator, int seed) {
            this.generator = generator;
            this.seed = seed;
        }
    }
}

