/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.projection;

import repast.simphony.query.space.projection.SpatialPredicate;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.ShortestPath;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.projection.Projection;
import simphony.util.messages.MessageCenter;

public class Within
extends SpatialPredicate {
    private static MessageCenter msg = MessageCenter.getMessageCenter(Within.class);
    private Object obj1;
    private Object obj2;
    private double distance;
    private double distanceSq;

    public Within(Object obj1, Object obj2, double distance) {
        this.obj1 = obj1;
        this.obj2 = obj2;
        this.distance = distance;
        this.distanceSq = distance * distance;
    }

    @Override
    public boolean evaluate(Network network) {
        ShortestPath<Object> path = new ShortestPath<Object>(network);
        return path.getPathLength(this.obj1, this.obj2) <= this.distance;
    }

    @Override
    public boolean evaluate(ContinuousSpace space) {
        NdPoint p1 = space.getLocation(this.obj1);
        NdPoint p2 = space.getLocation(this.obj2);
        if (p1 != null && p2 != null) {
            return space.getDistanceSq(p1, p2) <= this.distanceSq;
        }
        return false;
    }

    @Override
    public boolean evaluate(Grid grid) {
        GridPoint p1 = grid.getLocation(this.obj1);
        GridPoint p2 = grid.getLocation(this.obj2);
        if (p1 != null && p2 != null) {
            return grid.getDistanceSq(p1, p2) <= this.distanceSq;
        }
        return false;
    }

    @Override
    public boolean evaluate(Projection projection) {
        return projection.evaluate(this);
    }

    public Object getObj1() {
        return this.obj1;
    }

    public Object getObj2() {
        return this.obj2;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getDistanceSq() {
        return this.distanceSq;
    }
}

