/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.grid;

import java.util.HashSet;
import repast.simphony.query.space.grid.AbstractGridQuery;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.util.collections.Contains;
import repast.simphony.util.collections.FilteredIterator;
import repast.simphony.util.collections.IterableAdaptor;
import repast.simphony.util.collections.IteratorOverIterables;

public class VNQuery<T>
extends AbstractGridQuery<T> {
    public VNQuery(Grid<T> grid, T source, int ... extent) {
        super(grid, source, extent);
    }

    private void setupMinMax(int size) {
        int i = 0;
        while (i < size) {
            double coord = this.point.getCoord(i);
            double max = coord + (double)this.extent[i];
            double min = coord - (double)this.extent[i];
            this.mins[i] = (int)min;
            this.maxs[i] = (int)max;
            if (!this.grid.isPeriodic()) {
                int dimension;
                int origin = this.dims.getOrigin(i);
                if (min < (double)(-origin)) {
                    min = -origin;
                }
                if (max > (double)((dimension = this.dims.getDimension(i)) - origin - 1)) {
                    max = dimension - origin - 1;
                }
                this.mins[i] = (int)min;
                this.maxs[i] = (int)max;
            }
            ++i;
        }
    }

    @Override
    public Iterable<T> query() {
        if (this.point == null) {
            return this.emptyList;
        }
        int size = this.dims.size();
        this.setupMinMax(size);
        return new IterableAdaptor(new VNIterator(this.point));
    }

    @Override
    public Iterable<T> query(Iterable<T> iter) {
        if (this.point == null) {
            return this.emptyList;
        }
        HashSet<T> set = new HashSet<T>();
        for (T item : iter) {
            set.add(item);
        }
        int size = this.dims.size();
        this.setupMinMax(size);
        return new FilteredIterator(new VNIterator(this.point), new Contains(set));
    }

    private class VNIterator
    extends IteratorOverIterables<T> {
        int dimIndex = 0;
        int valIndex;
        int max;
        int dimMax;
        int[] tmpPoint;
        int centerVal;
        GridPoint center;

        public VNIterator(GridPoint center) {
            this.center = center;
            int size = VNQuery.this.dims.size();
            this.dimMax = size - 1;
            this.valIndex = VNQuery.this.mins[this.dimIndex];
            this.max = VNQuery.this.maxs[this.dimIndex];
            this.centerVal = center.getCoord(this.dimIndex);
            this.tmpPoint = new int[size];
            center.toIntArray(this.tmpPoint);
            this.init();
        }

        @Override
        protected Iterable<T> getNext() {
            if (this.valIndex == this.centerVal) {
                ++this.valIndex;
            }
            while (this.valIndex > this.max) {
                ++this.dimIndex;
                if (this.dimIndex > this.dimMax) {
                    return null;
                }
                this.valIndex = VNQuery.this.mins[this.dimIndex];
                this.max = VNQuery.this.maxs[this.dimIndex];
                this.center.toIntArray(this.tmpPoint);
                this.centerVal = this.center.getCoord(this.dimIndex);
                if (this.valIndex != this.centerVal) continue;
                ++this.valIndex;
            }
            ++this.valIndex;
            return VNQuery.this.grid.getObjectsAt(this.tmpPoint);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

