/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.grid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import repast.simphony.query.space.grid.AbstractGridQuery;
import repast.simphony.space.grid.Grid;
import repast.simphony.util.collections.Contains;
import repast.simphony.util.collections.FilteredIterator;
import repast.simphony.util.collections.IterableAdaptor;
import repast.simphony.util.collections.IteratorOverIterables;

public class MooreQuery<T>
extends AbstractGridQuery<T> {
    private final List<T> EMPTY_ITER = new ArrayList<T>();

    public MooreQuery(Grid<T> grid, T source, int ... extent) {
        super(grid, source, extent);
    }

    @Override
    public Iterable<T> query() {
        if (this.point == null) {
            return this.emptyList;
        }
        double px = this.point.getX();
        int size = this.dims.size();
        this.setupMinMax(size);
        if (size == 1) {
            return new IterableAdaptor(new Iterator1D(this.mins[0], this.maxs[0], (int)px));
        }
        if (size == 2) {
            double py = this.point.getY();
            return new IterableAdaptor(new Iterator2D(this.mins[0], this.mins[1], this.maxs[0], this.maxs[1], (int)px, (int)py));
        }
        double py = this.point.getY();
        int pz = this.point.getZ();
        return new IterableAdaptor(new Iterator3D(this.mins[0], this.mins[1], this.mins[2], this.maxs[0], this.maxs[1], this.maxs[2], (int)px, (int)py, pz));
    }

    private void setupMinMax(int size) {
        int i = 0;
        while (i < size) {
            double coord = this.point.getCoord(i);
            double max = coord + (double)this.extent[i];
            double min = coord - (double)this.extent[i];
            this.mins[i] = (int)min;
            this.maxs[i] = (int)max;
            if (!this.grid.isPeriodic()) {
                int dimension;
                int origin = this.dims.getOrigin(i);
                if (min < (double)(-origin)) {
                    min = -origin;
                }
                if (max > (double)((dimension = this.dims.getDimension(i)) - origin - 1)) {
                    max = dimension - origin - 1;
                }
                this.mins[i] = (int)min;
                this.maxs[i] = (int)max;
            }
            ++i;
        }
    }

    @Override
    public Iterable<T> query(Iterable<T> iter) {
        if (this.point == null) {
            return this.emptyList;
        }
        HashSet<T> set = new HashSet<T>();
        for (T item : iter) {
            set.add(item);
        }
        double px = this.point.getX();
        double py = this.point.getY();
        int size = this.dims.size();
        this.setupMinMax(size);
        if (size == 2) {
            return new FilteredIterator(new Iterator2D(this.mins[0], this.mins[1], this.maxs[0], this.maxs[1], (int)px, (int)py), new Contains(set));
        }
        int pz = this.point.getZ();
        return new FilteredIterator(new Iterator3D(this.mins[0], this.mins[1], this.mins[2], this.maxs[0], this.maxs[1], this.maxs[2], (int)px, (int)py, pz), new Contains(set));
    }

    private class Iterator1D
    extends IteratorOverIterables<T> {
        int cx;
        int x;
        int xMax;

        public Iterator1D(int xMin, int xMax, int cx) {
            this.cx = cx;
            this.x = xMin;
            this.xMax = xMax;
            this.init();
        }

        @Override
        protected Iterable<T> getNext() {
            if (this.x == this.cx) {
                ++this.x;
            }
            if (this.x > this.xMax) {
                return null;
            }
            Iterable tmp = MooreQuery.this.grid.getObjectsAt(this.x++);
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Iterator2D
    extends IteratorOverIterables<T> {
        int cx;
        int cy;
        int x;
        int y;
        int xMax;
        int yMax;
        int yMin;

        public Iterator2D(int xMin, int yMin, int xMax, int yMax, int cx, int cy) {
            this.cy = cy;
            this.cx = cx;
            this.x = xMin;
            this.y = yMin;
            this.yMin = yMin;
            this.xMax = xMax;
            this.yMax = yMax;
            this.init();
        }

        @Override
        protected Iterable<T> getNext() {
            if (this.y > this.yMax) {
                this.y = this.yMin;
                ++this.x;
            }
            if (this.x > this.xMax) {
                return null;
            }
            List tmp = this.x == this.cx && this.y == this.cy ? MooreQuery.this.EMPTY_ITER : MooreQuery.this.grid.getObjectsAt(this.x, this.y);
            ++this.y;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Iterator3D
    extends IteratorOverIterables<T> {
        int cx;
        int cy;
        int cz;
        int x;
        int y;
        int z;
        int xMax;
        int yMax;
        int yMin;
        int xMin;
        int zMax;

        public Iterator3D(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, int cx, int cy, int cz) {
            this.cy = cy;
            this.cx = cx;
            this.cz = cz;
            this.x = xMin;
            this.y = yMin;
            this.z = zMin;
            this.yMin = yMin;
            this.xMin = xMin;
            this.xMax = xMax;
            this.yMax = yMax;
            this.zMax = zMax;
            this.init();
        }

        @Override
        protected Iterable<T> getNext() {
            if (this.y > this.yMax) {
                this.y = this.yMin;
                ++this.x;
            }
            if (this.x > this.xMax) {
                this.x = this.xMin;
                ++this.z;
            }
            if (this.z > this.zMax) {
                return null;
            }
            List tmp = this.x == this.cx && this.y == this.cy && this.z == this.cz ? MooreQuery.this.EMPTY_ITER : MooreQuery.this.grid.getObjectsAt(this.x, this.y, this.z);
            ++this.y;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

