/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.grid;

import java.util.HashSet;
import org.apache.commons.collections15.iterators.IteratorChain;
import repast.simphony.context.Context;
import repast.simphony.query.WithinDistance;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.util.RangeCombination;
import repast.simphony.util.collections.IterableAdaptor;

public class GridWithin<T>
extends WithinDistance<T> {
    private Grid<T> space;

    public GridWithin(Context<T> context, T obj, double distance) {
        super(context, distance, obj);
    }

    public GridWithin(Grid<T> space, T obj, double distance) {
        super(null, distance, obj);
        this.space = space;
    }

    @Override
    protected Iterable<T> createIterable() {
        return this.createIterable(this.space);
    }

    @Override
    private Iterable<T> createIterable(Grid<T> space) {
        GridPoint origin = space.getLocation(this.obj);
        if (origin == null) {
            return EMPTY;
        }
        if (origin.dimensionCount() == 1) {
            return new IterableCreator1D<T>(this.distance, origin, space, this.obj).create();
        }
        if (origin.dimensionCount() == 2) {
            return new IterableCreator2D<T>(this.distance, origin, space, this.obj).create();
        }
        if (origin.dimensionCount() == 3) {
            return new IterableCreator3D<T>(this.distance, origin, space, this.obj).create();
        }
        return new IterableCreatorND<T>(this.distance, origin, space, this.obj).create();
    }

    @Override
    protected Iterable<T> createIterable(Context<T> context) {
        IteratorChain chain = new IteratorChain();
        for (Grid space : context.getProjections(Grid.class)) {
            GridPoint origin = space.getLocation(this.obj);
            if (origin == null) continue;
            chain.addIterator(this.createIterable(space).iterator());
        }
        return new IterableAdaptor(chain);
    }

    private static abstract class IterableCreator<T> {
        Grid<T> space;
        GridPoint origin;
        double distSq;
        double distance;
        Object target;

        public IterableCreator(double distance, GridPoint origin, Grid<T> space, Object target) {
            this.distSq = distance * distance;
            this.distance = distance;
            this.origin = origin;
            this.space = space;
            this.target = target;
        }

        public int getMin(int index) {
            int val = (int)Math.floor((double)this.origin.getCoord(index) - this.distance);
            if (!this.space.isPeriodic()) {
                return Math.max(this.space.getDimensions().getOrigin(index), val);
            }
            return val;
        }

        public int getMax(int index) {
            int val = (int)Math.ceil((double)this.origin.getCoord(index) + this.distance);
            if (!this.space.isPeriodic()) {
                GridDimensions dims = this.space.getDimensions();
                return Math.min(dims.getOrigin(index) + dims.getDimension(index) - 1, val);
            }
            return val;
        }

        abstract Iterable<T> create();
    }

    private static class IterableCreator1D<T>
    extends IterableCreator {
        public IterableCreator1D(double distance, GridPoint origin, Grid<T> space, Object target) {
            super(distance, origin, space, target);
        }

        @Override
        Iterable<T> create() {
            HashSet set = new HashSet();
            int start = this.getMin(0);
            int end = this.getMax(0);
            MutablePoint pt = new MutablePoint(0);
            int i = start;
            while (i <= end) {
                pt.setCoord(0, i);
                if (this.space.getDistanceSq(this.origin, pt) <= this.distSq) {
                    for (Object obj : this.space.getObjectsAt(i)) {
                        set.add(obj);
                    }
                }
                ++i;
            }
            set.remove(this.target);
            return set;
        }
    }

    private static class IterableCreator2D<T>
    extends IterableCreator {
        public IterableCreator2D(double distance, GridPoint origin, Grid<T> space, Object target) {
            super(distance, origin, space, target);
        }

        @Override
        Iterable<T> create() {
            HashSet set = new HashSet();
            int xStart = this.getMin(0);
            int xEnd = this.getMax(0);
            int yStart = this.getMin(1);
            int yEnd = this.getMax(1);
            MutablePoint pt = new MutablePoint(0, 0);
            int x = xStart;
            while (x <= xEnd) {
                pt.setCoord(0, x);
                int y = yStart;
                while (y <= yEnd) {
                    pt.setCoord(1, y);
                    if (this.space.getDistanceSq(this.origin, pt) <= this.distSq) {
                        for (Object obj : this.space.getObjectsAt(x, y)) {
                            set.add(obj);
                        }
                    }
                    ++y;
                }
                ++x;
            }
            set.remove(this.target);
            return set;
        }
    }

    private static class IterableCreator3D<T>
    extends IterableCreator {
        public IterableCreator3D(double distance, GridPoint origin, Grid<T> space, Object target) {
            super(distance, origin, space, target);
        }

        @Override
        Iterable<T> create() {
            HashSet set = new HashSet();
            int xStart = this.getMin(0);
            int xEnd = this.getMax(0);
            int yStart = this.getMin(1);
            int yEnd = this.getMax(1);
            int zStart = this.getMin(2);
            int zEnd = this.getMax(2);
            MutablePoint pt = new MutablePoint(0, 0, 0);
            int x = xStart;
            while (x <= xEnd) {
                pt.setCoord(0, x);
                int y = yStart;
                while (y <= yEnd) {
                    pt.setCoord(1, y);
                    int z = zStart;
                    while (z <= zEnd) {
                        pt.setCoord(2, z);
                        if (this.space.getDistanceSq(this.origin, pt) <= this.distSq) {
                            for (Object obj : this.space.getObjectsAt(x, y, z)) {
                                set.add(obj);
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            set.remove(this.target);
            return set;
        }
    }

    private static class IterableCreatorND<T>
    extends IterableCreator {
        public IterableCreatorND(double distance, GridPoint origin, Grid<T> space, Object target) {
            super(distance, origin, space, target);
        }

        @Override
        Iterable<T> create() {
            HashSet set = new HashSet();
            RangeCombination.RangeComboBuilder builder = new RangeCombination.RangeComboBuilder();
            int i = 0;
            int n = this.origin.dimensionCount();
            while (i < n) {
                int min = this.getMin(i);
                int max = this.getMax(i);
                builder.addRange(min, max);
                ++i;
            }
            RangeCombination combo = builder.build();
            MutablePoint pt = new MutablePoint(new int[combo.numRanges()]);
            while (combo.hasNext()) {
                int[] coords = pt.getCoords();
                combo.next(coords);
                if (!(this.space.getDistanceSq(this.origin, pt) <= this.distSq)) continue;
                for (Object obj : this.space.getObjectsAt(coords)) {
                    set.add(obj);
                }
            }
            set.remove(this.target);
            return set;
        }
    }

    private static class MutablePoint
    extends GridPoint {
        public MutablePoint(int ... point) {
            super(point);
        }

        void setCoord(int index, int value) {
            this.point[index] = value;
        }

        public int[] getCoords() {
            return this.point;
        }
    }
}

