/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.grid;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.query.space.grid.GridCell;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;

public class GridCellNgh<T> {
    private GridPoint point;
    protected Grid<? extends Object> grid;
    protected int[] extent;
    protected GridDimensions dims;
    protected int[] mins;
    protected int[] maxs;
    protected Class<T> clazz;

    public GridCellNgh(Grid<? extends Object> grid, GridPoint point, Class<T> clazz, int ... extent) {
        this.clazz = clazz;
        this.grid = grid;
        this.dims = grid.getDimensions();
        int size = this.dims.size();
        if (size > 3 || size < 1) {
            throw new IllegalArgumentException("Query is only supported on 1D, 2D and 3D grids");
        }
        this.mins = new int[size];
        this.maxs = new int[size];
        this.point = point;
        this.setExtent(size, extent);
        this.setupMinMax(size);
    }

    private void setExtent(int size, int ... extent) {
        if (extent == null || extent.length == 0) {
            extent = new int[size];
            int i = 0;
            while (i < size) {
                extent[i] = 1;
                ++i;
            }
        }
        if (extent.length != this.dims.size()) {
            throw new IllegalArgumentException("Number of extents must match the number of grid dimensions");
        }
        this.extent = extent;
    }

    private void addCell(List<GridCell<T>> list, int ... pt) {
        GridPoint gpt = new GridPoint(pt);
        if (this.grid.isPeriodic()) {
            this.grid.getGridPointTranslator().transform(gpt, pt);
        }
        GridCell<T> cell = new GridCell<T>(gpt, this.clazz);
        list.add(cell);
        for (Object object : this.grid.getObjectsAt(pt)) {
            cell.addObject(object);
        }
    }

    private void setupMinMax(int size) {
        int i = 0;
        while (i < size) {
            double coord = this.point.getCoord(i);
            double max = coord + (double)this.extent[i];
            double min = coord - (double)this.extent[i];
            this.mins[i] = (int)min;
            this.maxs[i] = (int)max;
            if (!this.grid.isPeriodic()) {
                int dimension;
                int origin = this.dims.getOrigin(i);
                if (min < (double)(-origin)) {
                    min = -origin;
                }
                if (max > (double)((dimension = this.dims.getDimension(i)) - origin - 1)) {
                    max = dimension - origin - 1;
                }
                this.mins[i] = (int)min;
                this.maxs[i] = (int)max;
            }
            ++i;
        }
    }

    public List<GridCell<T>> getNeighborhood(boolean includeCenter) {
        ArrayList<GridCell<T>> list = new ArrayList<GridCell<T>>();
        if (this.mins.length == 1) {
            int i = this.mins[0];
            while (i <= this.maxs[0]) {
                if (includeCenter) {
                    this.addCell(list, i);
                } else if (i != this.point.getX()) {
                    this.addCell(list, i);
                }
                ++i;
            }
        } else if (this.mins.length == 2) {
            int x = this.mins[0];
            while (x <= this.maxs[0]) {
                int y = this.mins[1];
                while (y <= this.maxs[1]) {
                    if (includeCenter) {
                        this.addCell(list, x, y);
                    } else if (x != this.point.getX() || y != this.point.getY()) {
                        this.addCell(list, x, y);
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int x = this.mins[0];
            while (x <= this.maxs[0]) {
                int y = this.mins[1];
                while (y <= this.maxs[1]) {
                    int z = this.mins[2];
                    while (z <= this.maxs[2]) {
                        if (includeCenter) {
                            this.addCell(list, x, y, z);
                        } else if (x != this.point.getX() || y != this.point.getY() || this.point.getZ() != z) {
                            this.addCell(list, x, y, z);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return list;
    }
}

