/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.grid;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.query.Query;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;

public abstract class AbstractGridQuery<T>
implements Query<T> {
    protected List<T> emptyList = new ArrayList<T>(0);
    protected Grid<T> grid;
    protected GridPoint point;
    protected int[] extent;
    protected GridDimensions dims;
    protected int[] mins;
    protected int[] maxs;

    public AbstractGridQuery(Grid<T> grid, T source, int ... extent) {
        this.grid = grid;
        this.dims = grid.getDimensions();
        int size = this.dims.size();
        if (size > 3 || size < 1) {
            throw new IllegalArgumentException("Query is only supported on 1D, 2D and 3D grids");
        }
        this.mins = new int[size];
        this.maxs = new int[size];
        this.point = grid.getLocation(source);
        this.setExtent(size, extent);
    }

    private void setExtent(int size, int ... extent) {
        if (extent == null || extent.length == 0) {
            extent = new int[size];
            int i = 0;
            while (i < size) {
                extent[i] = 1;
                ++i;
            }
        }
        if (extent.length != this.dims.size()) {
            throw new IllegalArgumentException("Number of extents must match the number of grid dimensions");
        }
        this.extent = extent;
    }

    public void reset(T source, int ... extent) {
        this.setExtent(this.dims.size(), extent);
        this.point = this.grid.getLocation(source);
    }
}

