/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.graph;

import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.iterators.IteratorChain;
import repast.simphony.context.Context;
import repast.simphony.query.Query;
import repast.simphony.query.QueryUtils;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.ShortestPath;
import repast.simphony.util.collections.FilteredIterator;
import repast.simphony.util.collections.IterableAdaptor;

public class NetPathWithin<T>
implements Query<T> {
    private Network<T> network;
    private T target;
    private Context<T> context;
    private double distance;

    public NetPathWithin(Context<T> context, T obj, double distance) {
        this.context = context;
        this.target = obj;
        this.distance = distance;
    }

    public NetPathWithin(Network<T> network, T obj, double distance) {
        this.network = network;
        this.target = obj;
        this.distance = distance;
    }

    @Override
    public Iterable<T> query() {
        if (this.context != null) {
            IteratorChain chain = new IteratorChain();
            for (Network net : this.context.getProjections(Network.class)) {
                ShortestPath path = new ShortestPath(net);
                chain.addIterator(new FilteredIterator(net.getNodes().iterator(), new DistancePredicate(path, this.distance, this.target)));
            }
            return new IterableAdaptor(chain);
        }
        ShortestPath<T> path = new ShortestPath<T>(this.network);
        return new FilteredIterator<T>(this.network.getNodes().iterator(), new DistancePredicate(path, this.distance, this.target));
    }

    @Override
    public Iterable<T> query(Iterable<T> set) {
        return new FilteredIterator<T>(this.query().iterator(), QueryUtils.createContains(set));
    }

    private static class DistancePredicate
    implements Predicate {
        private ShortestPath shortest;
        private double dist;
        private Object self;

        public DistancePredicate(ShortestPath shortest, double dist, Object self) {
            this.shortest = shortest;
            this.dist = dist;
            this.self = self;
        }

        public boolean evaluate(Object t) {
            return !this.self.equals(t) && this.shortest.getPathLength(this.self, t) <= this.dist;
        }
    }
}

