/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.continuous;

import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.iterators.IteratorChain;
import repast.simphony.context.Context;
import repast.simphony.query.WithinDistance;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.util.collections.FilteredIterator;
import repast.simphony.util.collections.IterableAdaptor;

public class ContinuousWithin<T>
extends WithinDistance<T> {
    private ContinuousSpace<T> space;

    public ContinuousWithin(Context<T> context, T obj, double distance) {
        super(context, distance, obj);
    }

    public ContinuousWithin(ContinuousSpace<T> space, T obj, double distance) {
        super(null, distance, obj);
        this.space = space;
    }

    @Override
    protected Iterable<T> createIterable() {
        NdPoint origin = this.space.getLocation(this.obj);
        if (origin == null) {
            return EMPTY;
        }
        return new FilteredIterator<T>(this.space.getObjects().iterator(), new WithinPredicate(this.distanceSq, origin, this.space, this.obj));
    }

    @Override
    protected Iterable<T> createIterable(Context<T> context) {
        IteratorChain chain = new IteratorChain();
        for (ContinuousSpace space : context.getProjections(ContinuousSpace.class)) {
            NdPoint origin = space.getLocation(this.obj);
            if (origin == null) continue;
            chain.addIterator(new FilteredIterator(space.getObjects().iterator(), new WithinPredicate(this.distanceSq, origin, space, this.obj)));
        }
        return new IterableAdaptor(chain);
    }

    private static class WithinPredicate
    implements Predicate {
        private ContinuousSpace space;
        private NdPoint origin;
        private double distSq;
        private Object target;

        public WithinPredicate(double distSq, NdPoint origin, ContinuousSpace space, Object target) {
            this.distSq = distSq;
            this.origin = origin;
            this.space = space;
            this.target = target;
        }

        public boolean evaluate(Object o) {
            return !o.equals(this.target) && this.space.getDistanceSq(this.space.getLocation(o), this.origin) <= this.distSq;
        }
    }
}

