/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.collections15.Predicate;
import repast.simphony.context.Context;
import repast.simphony.query.AbstractPropertyQuery;

public class PropertyGreaterThan<T>
extends AbstractPropertyQuery<T> {
    public PropertyGreaterThan(Context<T> context, String propertyName, Number propertyValue) {
        super(context, propertyName, propertyValue);
    }

    @Override
    protected Predicate<T> createPredicate(Context<T> context, String propertyName) {
        try {
            HashMap<Class, FastMethod> methodMap = new HashMap<Class, FastMethod>();
            block2: for (Class clazz : context.getAgentTypes()) {
                PropertyDescriptor[] pds;
                PropertyDescriptor[] propertyDescriptorArray = pds = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors();
                int n = pds.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                    if (pd.getName().equalsIgnoreCase(propertyName)) {
                        Method readMethod = pd.getReadMethod();
                        if (readMethod == null) continue block2;
                        Class<?> returnType = readMethod.getReturnType();
                        if (Number.class.isAssignableFrom(returnType) || primNums.contains(returnType)) {
                            methodMap.put(clazz, FastClass.create(readMethod.getDeclaringClass()).getMethod(readMethod));
                            continue block2;
                        }
                        IllegalArgumentException ex = new IllegalArgumentException("Property '" + propertyName + "' must be a numeric property");
                        AbstractPropertyQuery.msgCenter.error((Object)"Error while creating Property query", (Throwable)ex, new Object[0]);
                        throw ex;
                    }
                    ++n2;
                }
            }
            if (methodMap.size() == 0) {
                this.propertyNotFound(propertyName);
            }
            return new GreaterThan(methodMap);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            AbstractPropertyQuery.msgCenter.error((Object)"Error while creating Property query", (Throwable)e, new Object[0]);
            return null;
        }
    }

    private class GreaterThan<T>
    implements Predicate<T> {
        Map<Class, FastMethod> methodMap;

        public GreaterThan(Map<Class, FastMethod> methodMap) {
            this.methodMap = methodMap;
        }

        public boolean evaluate(T t) {
            FastMethod method = this.methodMap.get(t.getClass());
            if (method != null) {
                block4: {
                    Object obj = method.invoke(t, AbstractPropertyQuery.EMPTY);
                    if (obj != null && PropertyGreaterThan.this.propertyValue != null) break block4;
                    return false;
                }
                try {
                    return ((Number)method.invoke(t, AbstractPropertyQuery.EMPTY)).doubleValue() > ((Number)PropertyGreaterThan.this.propertyValue).doubleValue();
                }
                catch (InvocationTargetException e) {
                    AbstractPropertyQuery.msgCenter.error((Object)"Error evaluting property greater than predicate", (Throwable)e, new Object[0]);
                }
            }
            return false;
        }
    }
}

