/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.Predicate;
import repast.simphony.context.Context;
import repast.simphony.query.Query;
import repast.simphony.query.QueryUtils;
import repast.simphony.util.collections.FilteredIterator;
import simphony.util.messages.MessageCenter;

public abstract class AbstractPropertyQuery<T>
implements Query<T> {
    protected static final MessageCenter msgCenter = MessageCenter.getMessageCenter(AbstractPropertyQuery.class);
    protected static final Object[] EMPTY = new Object[0];
    protected static Set<Class> primNums = new HashSet<Class>();
    private Context<T> context;
    protected Object propertyValue;
    private Predicate<T> predicate;
    private String propertyName;

    static {
        primNums.add(Integer.TYPE);
        primNums.add(Double.TYPE);
        primNums.add(Float.TYPE);
        primNums.add(Long.TYPE);
        primNums.add(Character.TYPE);
        primNums.add(Byte.TYPE);
    }

    public AbstractPropertyQuery(Context<T> context, String propertyName, Object propertyValue) {
        this.context = context;
        this.propertyValue = propertyValue;
        this.propertyName = propertyName;
    }

    public Predicate<T> getQueryPredicate() {
        return this.predicate;
    }

    protected abstract Predicate<T> createPredicate(Context<T> var1, String var2);

    @Override
    public Iterable<T> query() {
        if (this.predicate == null) {
            this.predicate = this.createPredicate(this.context, this.propertyName);
        }
        return new FilteredIterator(this.context.iterator(), this.predicate);
    }

    protected void propertyNotFound(String propertyName) {
        IllegalArgumentException ex = new IllegalArgumentException("Property '" + propertyName + "' not found.");
        msgCenter.warn((Object)"Possible error while creating property query", (Throwable)ex, new Object[0]);
    }

    @Override
    public Iterable<T> query(Iterable<T> iter) {
        return new FilteredIterator<T>(this.query().iterator(), QueryUtils.createContains(iter));
    }
}

