/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.util.HashMap;
import java.util.Map;
import repast.simphony.parameter.StringConverter;

public class StringConverterFactory {
    private static StringConverterFactory instance;
    private Map<Class, StringConverter> converters = new HashMap<Class, StringConverter>();

    public static StringConverterFactory instance() {
        if (instance == null) {
            instance = new StringConverterFactory();
        }
        return instance;
    }

    private StringConverterFactory() {
        this.converters.put(Integer.TYPE, new IntConverter());
        this.converters.put(Integer.class, new IntConverter());
        this.converters.put(Float.TYPE, new FloatConverter());
        this.converters.put(Float.class, new FloatConverter());
        this.converters.put(Long.class, new LongConverter());
        this.converters.put(Long.TYPE, new LongConverter());
        this.converters.put(Double.class, new DoubleConverter());
        this.converters.put(Double.TYPE, new DoubleConverter());
        this.converters.put(Byte.class, new ByteConverter());
        this.converters.put(Byte.TYPE, new ByteConverter());
        this.converters.put(Boolean.TYPE, new BooleanConverter());
        this.converters.put(Boolean.class, new BooleanConverter());
        this.converters.put(Short.TYPE, new ShortConverter());
        this.converters.put(Short.class, new ShortConverter());
        this.converters.put(String.class, new StringStringConverter());
    }

    public <T> StringConverter<T> getConverter(Class<T> clazz) {
        return this.converters.get(clazz);
    }

    public <T> void addConverter(Class<T> clazz, StringConverter<T> converter) {
        this.converters.put(clazz, converter);
    }

    public static class BooleanConverter
    extends PrimConverter {
        public Object fromString(String strRep) {
            return Boolean.valueOf(strRep);
        }
    }

    public static class ByteConverter
    extends PrimConverter {
        public Object fromString(String strRep) {
            return Byte.valueOf(strRep);
        }
    }

    public static class DoubleConverter
    extends PrimConverter {
        public Object fromString(String strRep) {
            return Double.valueOf(strRep);
        }
    }

    public static class FloatConverter
    extends PrimConverter {
        public Object fromString(String strRep) {
            return Float.valueOf(strRep);
        }
    }

    public static class IntConverter
    extends PrimConverter {
        public Object fromString(String strRep) {
            return Integer.valueOf(strRep);
        }
    }

    public static class LongConverter
    extends PrimConverter {
        public Object fromString(String strRep) {
            return Long.valueOf(strRep);
        }
    }

    private static abstract class PrimConverter
    implements StringConverter {
        private PrimConverter() {
        }

        public String toString(Object obj) {
            return obj.toString();
        }
    }

    public static class ShortConverter
    extends PrimConverter {
        public Object fromString(String strRep) {
            return Short.valueOf(strRep);
        }
    }

    public static class StringStringConverter
    implements StringConverter {
        public String toString(Object obj) {
            return obj.toString();
        }

        public Object fromString(String strRep) {
            return strRep;
        }
    }
}

