/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang3.Range;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import repast.simphony.parameter.DefaultParameters;
import repast.simphony.parameter.Parameters;

public class ParametersWriter {
    private void write(Parameters params, Writer writer, String templateFile) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("parameters", (Object)params);
        context.put("NULL", Parameters.NULL);
        String template = this.getClass().getPackage().getName();
        template = template.replace('.', '/');
        template = String.valueOf(template) + "/" + templateFile;
        try {
            Velocity.mergeTemplate((String)template, (String)"UTF-8", (Context)context, (Writer)writer);
        }
        catch (Exception ex) {
            IOException ioEx = new IOException("Error writing parameters");
            ioEx.initCause(ex);
            throw ioEx;
        }
    }

    public String writeValuesToString(Parameters params) throws IOException {
        StringWriter writer = new StringWriter();
        this.write(params, writer, "params.vt");
        return writer.toString();
    }

    public void writeValuesToFile(Parameters params, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.write(params, writer, "params.vt");
        writer.close();
    }

    public void writeSpecificationToFile(Parameters params, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.write(params, writer, "parameters.vt");
        writer.close();
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.put("resource.loader", "class");
            props.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
            props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            Velocity.init((Properties)props);
            DefaultParameters p = new DefaultParameters();
            p.addParameter("foo", String.class, "Hello", true);
            p.addParameter("bar", Integer.TYPE, 12, false);
            p.addParameter("test", "Test Number", Integer.TYPE, 10, false);
            p.addConstraint("foo", Arrays.asList("Hello", "Test 1", "test2", "test 3"));
            p.addConstraint("bar", Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15)));
            ParametersWriter writer = new ParametersWriter();
            writer.writeValuesToFile(p, new File("/Users/kehrer/tmp/params.xml"));
            writer.writeSpecificationToFile(p, new File("/Users/kehrer/tmp/parameters.xml"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

