/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSchema;
import repast.simphony.parameter.ParameterUtils;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.Schema;

public class ParametersValuesLoader
extends DefaultHandler2 {
    private static final String PARAMETER = "parameter";
    public static Map<String, Class> typeMap = new HashMap<String, Class>();
    private Map<String, String> nameValMap = new HashMap<String, String>();

    static {
        typeMap.put("int", Integer.TYPE);
        typeMap.put("double", Double.TYPE);
        typeMap.put("long", Long.TYPE);
        typeMap.put("float", Float.TYPE);
        typeMap.put("boolean", Boolean.TYPE);
        typeMap.put("byte", Byte.TYPE);
        typeMap.put("short", Short.TYPE);
        typeMap.put("String", String.class);
        typeMap.put("string", String.class);
    }

    public ParametersValuesLoader(File file) throws IOException, SAXException, ParserConfigurationException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(file, (DefaultHandler)this);
    }

    public ParametersValuesLoader(String str) throws IOException, SAXException, ParserConfigurationException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(new InputSource(new StringReader(str)), (DefaultHandler)this);
    }

    public void loadValues(Parameters params) throws ParameterFormatException {
        for (String name : this.nameValMap.keySet()) {
            String val = this.nameValMap.get(name);
            Schema schema = params.getSchema();
            ParameterSchema details = schema.getDetails(name);
            if (details.getConverter() != null) {
                params.setValue(name, val);
                continue;
            }
            Class type = details.getType();
            Object[] vals = ParameterUtils.parseDefaultValue(type, name, val);
            params.setValue(name, vals[0]);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(PARAMETER)) {
            String name = attributes.getValue("name");
            String defaultValue = attributes.getValue("value");
            if (name == null || defaultValue == null) {
                throw new SAXException("Parameter element is missing required attributes");
            }
            this.nameValMap.put(name, defaultValue);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.nameValMap.size() == 0) {
            throw new SAXException("Error in parameter file format: no parameters found");
        }
    }
}

