/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSchema;
import repast.simphony.parameter.ParameterUtils;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.StringConverter;

public class ParametersParser
extends DefaultHandler2 {
    private static final String PARAMETER = "parameter";
    private ParametersCreator creator = new ParametersCreator();
    public static Map<String, Class> typeMap = new HashMap<String, Class>();

    static {
        typeMap.put("int", Integer.TYPE);
        typeMap.put("double", Double.TYPE);
        typeMap.put("long", Long.TYPE);
        typeMap.put("float", Float.TYPE);
        typeMap.put("boolean", Boolean.TYPE);
        typeMap.put("byte", Byte.TYPE);
        typeMap.put("short", Short.TYPE);
        typeMap.put("String", String.class);
        typeMap.put("string", String.class);
    }

    public ParametersParser(Parameters params, File file) throws IOException, SAXException, ParserConfigurationException {
        if (params != null) {
            this.creator.addParameters(params);
        }
        Parameters p = this.creator.createParameters();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(file, (DefaultHandler)this);
    }

    public ParametersParser(File file) throws ParserConfigurationException, SAXException, IOException {
        this(null, file);
    }

    public Parameters getParameters() {
        Parameters params = this.creator.createParameters();
        ParameterSchema details = params.getSchema().getDetails("randomSeed");
        if (details != null && params.getValue("randomSeed") == Parameters.NULL) {
            int val = (int)System.currentTimeMillis();
            if (val < 0) {
                val = Math.abs(val);
            }
            params.setValue("randomSeed", val);
        }
        return params;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (qName.equals(PARAMETER)) {
                String list;
                String name = attributes.getValue("name");
                String sType = attributes.getValue("type");
                String defaultValue = attributes.getValue("defaultValue");
                if (name == null || sType == null || defaultValue == null) {
                    throw new ParameterFormatException("Parameter element is missing required attributes");
                }
                String strConvertor = attributes.getValue("converter");
                StringConverter converter = null;
                if (strConvertor != null) {
                    Class<?> clazz = Class.forName(strConvertor);
                    converter = (StringConverter)clazz.newInstance();
                }
                String readOnly = attributes.getValue("isReadOnly");
                Class<?> type = typeMap.get(sType);
                if (type == null) {
                    type = Class.forName(sType);
                }
                Object defVal = defaultValue.equals("__NULL__") ? null : (converter != null ? (Object)converter.fromString(defaultValue) : ParameterUtils.parseDefaultValue(type, name, defaultValue)[0]);
                if (name.equals("randomSeed") && defVal == null && this.creator.contains("randomSeed")) {
                    return;
                }
                String displayName = attributes.getValue("displayName");
                if (displayName == null) {
                    displayName = name;
                }
                this.creator.addParameter(name, displayName, type, defVal, Boolean.parseBoolean(readOnly));
                if (converter != null) {
                    this.creator.addConvertor(name, converter);
                }
                if ((list = attributes.getValue("values")) != null) {
                    if (converter == null) {
                        Object[] vals = ParameterUtils.parseDefaultValue(type, name, list);
                        this.creator.addConstraint(name, Arrays.asList(vals));
                    } else {
                        Object[] vals;
                        ArrayList objs = new ArrayList();
                        Object[] objectArray = vals = ParameterUtils.parseDefaultValue(String.class, name, list);
                        int n = vals.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object val = objectArray[n2];
                            objs.add(converter.fromString(val.toString()));
                            ++n2;
                        }
                        this.creator.addConstraint(name, objs);
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new SAXException("Unable to creates parameters", e);
        }
        catch (ParameterFormatException ex) {
            throw new SAXException("Unable to convert parameter type. Please use a convertor.", ex);
        }
        catch (IllegalAccessException e) {
            throw new SAXException("Unable to creates parameters. Bad convertor value", e);
        }
        catch (InstantiationException e) {
            throw new SAXException("Unable to creates parameters. Bad convertor value", e);
        }
        catch (ClassCastException ex) {
            throw new SAXException("Unable to creates parameters. Convertor must implement StringConverter");
        }
    }
}

