/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.Range;
import repast.simphony.parameter.BoundParameters;
import repast.simphony.parameter.DefaultParameters;
import repast.simphony.parameter.Parameter;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSchema;
import repast.simphony.parameter.ParameterUtils;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.Schema;
import repast.simphony.parameter.StringConverter;
import simphony.util.messages.MessageCenter;

public class ParametersCreator {
    private static MessageCenter msg = MessageCenter.getMessageCenter(ParametersCreator.class);
    private DefaultParameters parameters = new DefaultParameters();

    public void addParameter(String name, Class type, Object value, boolean isReadOnly) {
        this.parameters.addParameter(name, type, value, isReadOnly);
    }

    public void addParameter(String name, String displayName, Class type, Object value, boolean isReadOnly) {
        this.parameters.addParameter(name, displayName, type, value, isReadOnly);
    }

    public boolean contains(String name) {
        return this.parameters.getSchema().contains(name);
    }

    public void addParameters(Parameters params) {
        Schema schema = params.getSchema();
        for (String name : schema.parameterNames()) {
            ParameterSchema details = schema.getDetails(name);
            String displayName = params.getDisplayName(name);
            if (displayName == null) {
                displayName = name;
            }
            Object defaultValue = params.getSchema().getDetails(name).getDefaultValue();
            this.addParameter(name, displayName, details.getType(), defaultValue, params.isReadOnly(name));
            this.parameters.setValue(name, params.getValue(name));
            if (details.getConstrainingList() != null) {
                this.addConstraint(name, details.getConstrainingList());
            }
            if (details.getConstrainingRange() != null) {
                this.addConstraint(name, details.getConstrainingRange());
            }
            if (details.getConverter() == null) continue;
            this.addConvertor(name, details.getConverter());
        }
    }

    public void addConstraint(String name, List constrainingList) {
        this.parameters.addConstraint(name, constrainingList);
    }

    public void addConvertor(String name, StringConverter converter) {
        this.parameters.addConvertor(name, converter);
    }

    public void addConstraint(String name, Range constrainingRange) {
        this.parameters.addConstraint(name, constrainingRange);
    }

    public BoundParameters createBoundParameters(Class clazz) throws IntrospectionException {
        PropertyDescriptor[] pds;
        BoundParameters parameters = new BoundParameters(this.parameters);
        BeanInfo info = Introspector.getBeanInfo(clazz, Object.class);
        PropertyDescriptor[] propertyDescriptorArray = pds = info.getPropertyDescriptors();
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param;
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            Method method = pd.getReadMethod();
            if (method != null && (param = method.getAnnotation(Parameter.class)) != null) {
                try {
                    Class<?> paramClass = method.getReturnType();
                    Object val = ParameterUtils.parseDefaultValue(paramClass, param.usageName(), param.defaultValue())[0];
                    parameters.addParameter(param.usageName(), param.displayName(), paramClass, val, pd.getReadMethod(), pd.getWriteMethod());
                }
                catch (ParameterFormatException ex) {
                    msg.warn((Object)"Unsupported parameter type", (Throwable)ex, new Object[0]);
                }
            }
            ++n2;
        }
        this.parameters = new DefaultParameters();
        return parameters;
    }

    public Parameters createParameters() {
        DefaultParameters ret = new DefaultParameters(this.parameters);
        this.parameters = new DefaultParameters();
        return ret;
    }

    public int getParameterCount() {
        return this.parameters.getSchema().size();
    }
}

