/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.parameter.ListTokenizer;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.StringConverter;
import repast.simphony.util.ClassUtilities;

public class ParameterUtils {
    public static Object[] parseDefaultValue(Class type, String name, String val) throws ParameterFormatException {
        if (val == null || val.trim().length() == 0) {
            if (ClassUtilities.isNumericType(type)) {
                val = "0";
            } else if (type.equals(String.class)) {
                val = "";
            } else if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                val = "false";
            }
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return ListTokenizer.parseIntValues(val, name);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return ListTokenizer.parseDoubleValues(val, name);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return ListTokenizer.parseLongValues(val, name);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return ListTokenizer.parseFloatValues(val, name);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return ListTokenizer.parseBooleanValues(val, name);
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return ListTokenizer.parseByteValues(val, name);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return ListTokenizer.parseShortValues(val, name);
        }
        if (type.equals(String.class)) {
            return ListTokenizer.parseStringValues(val);
        }
        throw new IllegalArgumentException("invalid type");
    }

    public static String getStringValue(Class type, StringConverter converter, List values) {
        StringBuilder retval = new StringBuilder();
        if (values != null && values.size() > 0) {
            ArrayList<String> strVals = new ArrayList<String>(values.size());
            boolean valContainsSpace = false;
            for (Object o : values) {
                String s = converter != null ? converter.toString(o) : o.toString();
                strVals.add(s);
                valContainsSpace |= s.indexOf(32) != -1;
            }
            for (String s : strVals) {
                if (valContainsSpace) {
                    retval.append('\'');
                }
                retval.append(s);
                if (valContainsSpace) {
                    retval.append('\'');
                }
                retval.append(' ');
            }
        }
        return retval.toString();
    }
}

