/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import repast.simphony.parameter.FileParameterType;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterType;
import repast.simphony.parameter.StringConverter;
import repast.simphony.parameter.StringConverterFactory;

public class ParameterTypeFactory {
    private static ParameterTypeFactory instance;
    private Map<Class<?>, ParameterType> types = new HashMap();

    public static ParameterTypeFactory instance() {
        if (instance == null) {
            instance = new ParameterTypeFactory();
        }
        return instance;
    }

    private ParameterTypeFactory() {
        ParameterType<Integer> type = new IntegerParameterType();
        this.types.put(Integer.TYPE, type);
        this.types.put(Integer.class, type);
        type = new LongParameterType();
        this.types.put(Long.TYPE, type);
        this.types.put(Long.class, type);
        type = new StringParameterType();
        this.types.put(String.class, type);
        type = new FloatParameterType();
        this.types.put(Float.TYPE, type);
        this.types.put(Float.class, type);
        type = new DoubleParameterType();
        this.types.put(Double.TYPE, type);
        this.types.put(Double.class, type);
        type = new ByteParameterType();
        this.types.put(Byte.TYPE, type);
        this.types.put(Byte.class, type);
        type = new ShortParameterType();
        this.types.put(Short.TYPE, type);
        this.types.put(Short.class, type);
        type = new BooleanParameterType();
        this.types.put(Boolean.TYPE, type);
        this.types.put(Boolean.class, type);
        type = new FileParameterType();
        this.types.put(File.class, type);
    }

    public <T> ParameterType<T> getParameterType(Class<T> clazz) {
        return this.types.get(clazz);
    }

    public <T> void addParameterType(Class<T> clazz, ParameterType<T> type) {
        this.types.put(clazz, type);
    }

    private class BooleanParameterType
    implements ParameterType<Boolean> {
        private BooleanParameterType() {
        }

        @Override
        public Class<Boolean> getJavaClass() {
            return Boolean.class;
        }

        @Override
        public Boolean getValue(String val) throws ParameterFormatException {
            if (val == null || val.trim().length() == 0) {
                return false;
            }
            StringTokenizer tok = new StringTokenizer(val, " ");
            try {
                return Boolean.parseBoolean(tok.nextToken());
            }
            catch (NumberFormatException ex) {
                throw new ParameterFormatException("Invalid parameter format '" + val + "'");
            }
        }

        @Override
        public StringConverter<Boolean> getConverter() {
            return StringConverterFactory.instance().getConverter(Boolean.class);
        }
    }

    private class ByteParameterType
    implements ParameterType<Byte> {
        private ByteParameterType() {
        }

        @Override
        public Class<Byte> getJavaClass() {
            return Byte.class;
        }

        @Override
        public Byte getValue(String val) throws ParameterFormatException {
            if (val == null || val.trim().length() == 0) {
                return (byte)0;
            }
            StringTokenizer tok = new StringTokenizer(val, " ");
            try {
                return Byte.parseByte(tok.nextToken());
            }
            catch (NumberFormatException ex) {
                throw new ParameterFormatException("Invalid parameter format '" + val + "'");
            }
        }

        @Override
        public StringConverter<Byte> getConverter() {
            return StringConverterFactory.instance().getConverter(Byte.class);
        }
    }

    private class DoubleParameterType
    implements ParameterType<Double> {
        private DoubleParameterType() {
        }

        @Override
        public Class<Double> getJavaClass() {
            return Double.class;
        }

        @Override
        public Double getValue(String val) throws ParameterFormatException {
            if (val == null || val.trim().length() == 0) {
                return 0.0;
            }
            StringTokenizer tok = new StringTokenizer(val, " ");
            try {
                return Double.parseDouble(tok.nextToken());
            }
            catch (NumberFormatException ex) {
                throw new ParameterFormatException("Invalid parameter format '" + val + "'");
            }
        }

        @Override
        public StringConverter<Double> getConverter() {
            return StringConverterFactory.instance().getConverter(Double.class);
        }
    }

    private class FloatParameterType
    implements ParameterType<Float> {
        private FloatParameterType() {
        }

        @Override
        public Class<Float> getJavaClass() {
            return Float.class;
        }

        @Override
        public Float getValue(String val) throws ParameterFormatException {
            if (val == null || val.trim().length() == 0) {
                return Float.valueOf(0.0f);
            }
            StringTokenizer tok = new StringTokenizer(val, " ");
            try {
                return Float.valueOf(Float.parseFloat(tok.nextToken()));
            }
            catch (NumberFormatException ex) {
                throw new ParameterFormatException("Invalid parameter format '" + val + "'");
            }
        }

        @Override
        public StringConverter<Float> getConverter() {
            return StringConverterFactory.instance().getConverter(Float.class);
        }
    }

    private class IntegerParameterType
    implements ParameterType<Integer> {
        private IntegerParameterType() {
        }

        @Override
        public Class<Integer> getJavaClass() {
            return Integer.class;
        }

        @Override
        public Integer getValue(String val) throws ParameterFormatException {
            if (val == null || val.trim().length() == 0) {
                return 0;
            }
            StringTokenizer tok = new StringTokenizer(val, " ");
            try {
                return Integer.parseInt(tok.nextToken());
            }
            catch (NumberFormatException ex) {
                throw new ParameterFormatException("Invalid parameter format '" + val + "'");
            }
        }

        @Override
        public StringConverter<Integer> getConverter() {
            return StringConverterFactory.instance().getConverter(Integer.class);
        }
    }

    private class LongParameterType
    implements ParameterType<Long> {
        private LongParameterType() {
        }

        @Override
        public Class<Long> getJavaClass() {
            return Long.class;
        }

        @Override
        public Long getValue(String val) throws ParameterFormatException {
            if (val == null || val.trim().length() == 0) {
                return 0L;
            }
            StringTokenizer tok = new StringTokenizer(val, " ");
            try {
                return Long.parseLong(tok.nextToken());
            }
            catch (NumberFormatException ex) {
                throw new ParameterFormatException("Invalid parameter format '" + val + "'");
            }
        }

        @Override
        public StringConverter<Long> getConverter() {
            return StringConverterFactory.instance().getConverter(Long.class);
        }
    }

    private class ShortParameterType
    implements ParameterType<Short> {
        private ShortParameterType() {
        }

        @Override
        public Class<Short> getJavaClass() {
            return Short.class;
        }

        @Override
        public Short getValue(String val) throws ParameterFormatException {
            if (val == null || val.trim().length() == 0) {
                return (short)0;
            }
            StringTokenizer tok = new StringTokenizer(val, " ");
            try {
                return Short.parseShort(tok.nextToken());
            }
            catch (NumberFormatException ex) {
                throw new ParameterFormatException("Invalid parameter format '" + val + "'");
            }
        }

        @Override
        public StringConverter<Short> getConverter() {
            return StringConverterFactory.instance().getConverter(Short.class);
        }
    }

    private class StringParameterType
    implements ParameterType<String> {
        private StringParameterType() {
        }

        @Override
        public Class<String> getJavaClass() {
            return String.class;
        }

        @Override
        public String getValue(String val) throws ParameterFormatException {
            if (val == null || val.trim().length() == 0) {
                return "";
            }
            StringTokenizer tok = new StringTokenizer(val, " ");
            return tok.nextToken();
        }

        @Override
        public StringConverter<String> getConverter() {
            return StringConverterFactory.instance().getConverter(String.class);
        }
    }
}

