/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import repast.simphony.parameter.ParameterFormatException;

public class ListTokenizer {
    public static Boolean[] parseBooleanValues(String values, String name) throws ParameterFormatException {
        try {
            StringTokenizer tok = new StringTokenizer(values, " ");
            ArrayList<Boolean> vals = new ArrayList<Boolean>();
            while (tok.hasMoreTokens()) {
                vals.add(Boolean.parseBoolean(tok.nextToken()));
            }
            return vals.toArray(new Boolean[0]);
        }
        catch (NumberFormatException ex) {
            throw new ParameterFormatException("Invalid format for parameter '" + name + "'", ex);
        }
    }

    public static Float[] parseFloatValues(String values, String name) throws ParameterFormatException {
        try {
            StringTokenizer tok = new StringTokenizer(values, " ");
            ArrayList<Float> vals = new ArrayList<Float>();
            while (tok.hasMoreTokens()) {
                vals.add(Float.valueOf(Float.parseFloat(tok.nextToken())));
            }
            return vals.toArray(new Float[0]);
        }
        catch (NumberFormatException ex) {
            throw new ParameterFormatException("Invalid format for parameter '" + name + "'", ex);
        }
    }

    public static Long[] parseLongValues(String values, String name) throws ParameterFormatException {
        try {
            StringTokenizer tok = new StringTokenizer(values, " ");
            ArrayList<Long> vals = new ArrayList<Long>();
            while (tok.hasMoreTokens()) {
                String val = tok.nextToken();
                if (val.endsWith("L") || val.endsWith("l")) {
                    val = val.substring(0, val.length() - 1);
                }
                vals.add(Long.parseLong(val));
            }
            return vals.toArray(new Long[0]);
        }
        catch (NumberFormatException ex) {
            throw new ParameterFormatException("Invalid format for parameter '" + name + "'", ex);
        }
    }

    public static Double[] parseDoubleValues(String values, String name) throws ParameterFormatException {
        try {
            StringTokenizer tok = new StringTokenizer(values, " ");
            ArrayList<Double> vals = new ArrayList<Double>();
            while (tok.hasMoreTokens()) {
                vals.add(Double.parseDouble(tok.nextToken()));
            }
            return vals.toArray(new Double[0]);
        }
        catch (NumberFormatException ex) {
            throw new ParameterFormatException("Invalid format for parameter '" + name + "'", ex);
        }
    }

    public static Byte[] parseByteValues(String values, String name) throws ParameterFormatException {
        try {
            StringTokenizer tok = new StringTokenizer(values, " ");
            ArrayList<Byte> vals = new ArrayList<Byte>();
            while (tok.hasMoreTokens()) {
                vals.add(Byte.parseByte(tok.nextToken()));
            }
            return vals.toArray(new Byte[0]);
        }
        catch (NumberFormatException ex) {
            throw new ParameterFormatException("Invalid format for parameter '" + name + "'", ex);
        }
    }

    public static Short[] parseShortValues(String values, String name) throws ParameterFormatException {
        try {
            StringTokenizer tok = new StringTokenizer(values, " ");
            ArrayList<Short> vals = new ArrayList<Short>();
            while (tok.hasMoreTokens()) {
                vals.add(Short.parseShort(tok.nextToken()));
            }
            return vals.toArray(new Short[0]);
        }
        catch (NumberFormatException ex) {
            throw new ParameterFormatException("Invalid format for parameter '" + name + "'", ex);
        }
    }

    public static Integer[] parseIntValues(String values, String name) throws ParameterFormatException {
        try {
            StringTokenizer tok = new StringTokenizer(values, " ");
            ArrayList<Integer> vals = new ArrayList<Integer>();
            while (tok.hasMoreTokens()) {
                vals.add(Integer.parseInt(tok.nextToken()));
            }
            return vals.toArray(new Integer[0]);
        }
        catch (NumberFormatException ex) {
            throw new ParameterFormatException("Invalid format for parameter '" + name + "'", ex);
        }
    }

    public static String[] parseStringValues(String values) {
        ArrayList<String> list = new ArrayList<String>();
        if (values.trim().length() == 0) {
            return new String[]{""};
        }
        if (values.contains("'")) {
            Pattern p = Pattern.compile("'(?>\\\\.|.)*?'");
            Matcher m1 = p.matcher(values);
            while (m1.find()) {
                String val = m1.group();
                list.add(val.substring(1, val.length() - 1));
            }
        } else {
            StringTokenizer tok = new StringTokenizer(values, " ");
            while (tok.hasMoreTokens()) {
                list.add(tok.nextToken());
            }
        }
        return list.toArray(new String[list.size()]);
    }
}

