/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Range;
import repast.simphony.parameter.DefaultParameterSchema;
import repast.simphony.parameter.IllegalParameterException;
import repast.simphony.parameter.ParameterSchema;
import repast.simphony.parameter.Schema;
import repast.simphony.parameter.StringConverter;
import repast.simphony.util.collections.Pair;

public class DefaultSchema
implements Schema {
    private Map<String, ParameterSchema> schemas = new HashMap<String, ParameterSchema>();

    public DefaultSchema() {
    }

    public DefaultSchema(Pair<String, Class>[] pairs) {
        Pair<String, Class>[] pairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<String, Class> pair = pairArray[n2];
            this.schemas.put(pair.getFirst(), new DefaultParameterSchema(pair.getFirst(), pair.getSecond(), null));
            ++n2;
        }
    }

    public boolean removeEntry(String name) {
        ParameterSchema ps = this.schemas.remove(name);
        return ps != null;
    }

    public void addEntry(String name, Class type, Object defValue) {
        this.schemas.put(name, new DefaultParameterSchema(name, type, defValue));
    }

    public void addConstraint(String name, List constrainingList) {
        ParameterSchema schema = this.schemas.get(name);
        DefaultParameterSchema newSchema = new DefaultParameterSchema(schema);
        newSchema.setConstrainingList(constrainingList);
        this.schemas.put(name, newSchema);
    }

    public void addConvertor(String name, StringConverter converter) {
        ParameterSchema schema = this.schemas.get(name);
        DefaultParameterSchema newSchema = new DefaultParameterSchema(schema);
        newSchema.setConvertor(converter);
        this.schemas.put(name, newSchema);
    }

    public void addConstraint(String name, Range constrainingRange) {
        ParameterSchema schema = this.schemas.get(name);
        DefaultParameterSchema newSchema = new DefaultParameterSchema(schema);
        newSchema.setConstrainingRange(constrainingRange);
        this.schemas.put(name, newSchema);
    }

    @Override
    public ParameterSchema getDetails(String paramName) {
        return this.schemas.get(paramName);
    }

    @Override
    public Iterable<String> parameterNames() {
        return this.schemas.keySet();
    }

    @Override
    public boolean validate(String paramName, Object obj) {
        ParameterSchema schema = this.schemas.get(paramName);
        if (schema == null) {
            throw new IllegalParameterException("Schema for parameter '" + paramName + "' not found.");
        }
        return schema.validate(obj);
    }

    @Override
    public boolean contains(String paramName) {
        return this.schemas.containsKey(paramName);
    }

    @Override
    public int size() {
        return this.schemas.size();
    }
}

