/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Range;
import repast.simphony.parameter.DefaultSchema;
import repast.simphony.parameter.IllegalParameterException;
import repast.simphony.parameter.MutableParameters;
import repast.simphony.parameter.ParameterSchema;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.Schema;
import repast.simphony.parameter.StringConverter;
import repast.simphony.util.ClassUtilities;

public class DefaultParameters
implements MutableParameters {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected Map<String, Object> values = new HashMap<String, Object>();
    protected Map<String, String> nameMap = new HashMap<String, String>();
    protected DefaultSchema schema = new DefaultSchema();
    protected Set<String> readOnly = new HashSet<String>();
    protected boolean changed;

    public DefaultParameters() {
    }

    public DefaultParameters(Parameters params) {
        Schema schema = params.getSchema();
        for (String name : schema.parameterNames()) {
            ParameterSchema details = schema.getDetails(name);
            String displayName = params.getDisplayName(name);
            if (displayName == null) {
                displayName = name;
            }
            Object defaultValue = params.getSchema().getDetails(name).getDefaultValue();
            this.addParameter(name, displayName, details.getType(), defaultValue, params.isReadOnly(name));
            if (params.getValue(name) != Parameters.NULL) {
                this.setValue(name, params.getValue(name));
            }
            if (details.getConstrainingList() != null) {
                this.addConstraint(name, details.getConstrainingList());
            }
            if (details.getConstrainingRange() != null) {
                this.addConstraint(name, details.getConstrainingRange());
            }
            if (details.getConverter() == null) continue;
            this.addConvertor(name, details.getConverter());
        }
    }

    @Override
    public Parameters clone() {
        try {
            return (Parameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public boolean removeParameter(String name) {
        boolean retval = this.schema.removeEntry(name);
        if (retval) {
            this.values.remove(name);
            this.nameMap.remove(name);
        }
        return retval;
    }

    @Override
    public void addParameter(String name, String displayName, Class type, Object value, boolean isReadOnly) {
        this.addParameter(name, type, value, isReadOnly);
        this.nameMap.put(name, displayName);
    }

    @Override
    public void addConstraint(String name, List constrainingList) {
        this.schema.addConstraint(name, constrainingList);
    }

    @Override
    public void addConvertor(String name, StringConverter converter) {
        this.schema.addConvertor(name, converter);
    }

    @Override
    public void addConstraint(String name, Range constrainingRange) {
        this.schema.addConstraint(name, constrainingRange);
    }

    protected void addParameter(String name, Class type, Object value, boolean isReadOnly) {
        if (value == null) {
            value = Parameters.NULL;
        }
        this.schema.addEntry(name, type, value);
        this.values.put(name, value);
        if (isReadOnly) {
            this.readOnly.add(name);
        }
        this.nameMap.put(name, name);
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Object getValue(String paramName) {
        if (this.schema.contains(paramName)) {
            return this.values.get(paramName);
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not found in the schema.");
    }

    @Override
    public Double getDouble(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Double.class || paramType == Double.TYPE) {
            return (Double)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of double type.");
    }

    @Override
    public Integer getInteger(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Integer.class || paramType == Integer.TYPE) {
            return (Integer)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of integer type.");
    }

    @Override
    public Boolean getBoolean(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Boolean.class || paramType == Boolean.TYPE) {
            return (Boolean)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of boolean type.");
    }

    @Override
    public String getString(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == String.class) {
            return (String)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of String type.");
    }

    @Override
    public Long getLong(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Long.class || paramType == Long.TYPE) {
            return (Long)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of long type.");
    }

    @Override
    public Float getFloat(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Float.class || paramType == Float.TYPE) {
            return (Float)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of float type.");
    }

    @Override
    public String getValueAsString(String paramName) {
        Object obj = this.getValue(paramName);
        return obj.equals(Parameters.NULL) ? "null" : this.schema.getDetails(paramName).toString(obj);
    }

    @Override
    public boolean isReadOnly(String paramName) {
        return this.readOnly.contains(paramName);
    }

    @Override
    public void setValue(String paramName, Object val) {
        Object newVal;
        Object tmpVal;
        ParameterSchema details = this.schema.getDetails(paramName);
        if (val.getClass().equals(String.class) && !details.getType().equals(String.class) && (tmpVal = details.fromString((String)val)) != null) {
            val = tmpVal;
        }
        if (!this.schema.validate(paramName, newVal = this.coerce(paramName, val))) {
            throw new IllegalParameterException("Schema violation when setting parameter '" + paramName + "' to " + val);
        }
        Object oldVal = this.values.get(paramName);
        this.values.put(paramName, newVal);
        this.changed = true;
        this.pcs.firePropertyChange(paramName, oldVal, val);
    }

    private Object coerce(String paramName, Object obj) {
        Class<?> objClass = obj.getClass();
        Class type = this.getSchema().getDetails(paramName).getType();
        if (ClassUtilities.isNumericType(type) && Number.class.isAssignableFrom(objClass)) {
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return ((Number)obj).doubleValue();
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                if (objClass.equals(Double.class) || objClass.equals(Long.class)) {
                    return obj;
                }
                return Float.valueOf(((Number)obj).floatValue());
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                if (objClass.equals(Float.TYPE) || objClass.equals(Double.TYPE)) {
                    return obj;
                }
                return ((Number)obj).longValue();
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                if (objClass.equals(Integer.class) || objClass.equals(Short.class) || objClass.equals(Byte.class)) {
                    return ((Number)obj).intValue();
                }
                return obj;
            }
        }
        return obj;
    }

    @Override
    public String getDisplayName(String paramName) {
        return this.nameMap.get(paramName);
    }
}

