/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Range;
import repast.simphony.parameter.IllegalParameterException;
import repast.simphony.parameter.ParameterSchema;
import repast.simphony.parameter.ParameterUtils;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.StringConverter;
import repast.simphony.parameter.StringConverterFactory;

public class DefaultParameterSchema
implements ParameterSchema {
    static Map<Class, Class> primitives = new HashMap<Class, Class>();
    private boolean isANumber;
    private List list;
    private Range range;
    private Class type;
    private Object defValue;
    private String name;
    private StringConverter converter;

    static {
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Boolean.TYPE, Boolean.class);
    }

    public DefaultParameterSchema(ParameterSchema schema) {
        this(schema.getName(), schema.getType(), schema.getDefaultValue());
        this.range = schema.getConstrainingRange();
        this.list = schema.getConstrainingList();
        this.converter = schema.getConverter();
    }

    public DefaultParameterSchema(String name, Class type, Object defValue) {
        this.type = type;
        this.defValue = defValue;
        this.name = name;
        this.isANumber = Number.class.isAssignableFrom(type) || primitives.containsKey(type);
        this.converter = StringConverterFactory.instance().getConverter(type);
    }

    public DefaultParameterSchema(String name, Class type, Object defValue, List possibleValues) {
        this(name, type, defValue);
        this.setConstrainingList(possibleValues);
    }

    public DefaultParameterSchema(String name, Class type, Object defValue, Range constrainingRange) {
        this(name, type, defValue);
        this.setConstrainingRange(constrainingRange);
    }

    @Override
    public StringConverter getConverter() {
        return this.converter;
    }

    public void setConvertor(StringConverter converter) {
        this.converter = converter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Object getDefaultValue() {
        return this.defValue;
    }

    @Override
    public void setDefaultValue(Object obj) {
        if (obj == null) {
            obj = Parameters.NULL;
        }
        if (!this.defValue.equals(obj)) {
            if (this.validate(obj)) {
                this.defValue = obj;
            } else {
                throw new IllegalParameterException("Schema violation when setting default value of parameter '" + this.name + "' to " + obj);
            }
        }
    }

    public void setConstrainingList(List list) {
        this.list = list;
        if (this.defValue != null && !this.validate(this.defValue)) {
            throw new IllegalParameterException("Constraining list '" + list + "' for parameter '" + this.name + "' does not contain default value '" + this.defValue + "'");
        }
    }

    public void setConstrainingRange(Range range) {
        this.range = range;
        if (this.defValue != null && !this.validate(this.defValue)) {
            throw new IllegalParameterException("Constraining range '" + range + "' for parameter '" + this.name + "' does not contain default value '" + this.defValue + "'");
        }
    }

    @Override
    public Range getConstrainingRange() {
        return this.range;
    }

    @Override
    public List getConstrainingList() {
        return this.list == null ? null : new ArrayList(this.list);
    }

    @Override
    public String getConstraintString() {
        String val = "";
        if (this.list != null) {
            val = ParameterUtils.getStringValue(this.type, this.converter, this.list);
        } else if (this.range != null) {
            val = this.range.toString();
        }
        return val;
    }

    @Override
    public boolean validate(Object obj) {
        Class<?> setType = obj.getClass();
        Class testingType = primitives.get(this.type);
        if (testingType == null) {
            testingType = this.type;
        }
        if (testingType.isAssignableFrom(setType)) {
            if (this.isANumber && this.range != null) {
                return this.range.contains((Object)((Number)obj).doubleValue());
            }
            if (this.list != null) {
                return this.list.contains(obj);
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString(Object obj) {
        return this.converter == null ? obj.toString() : this.converter.toString(obj);
    }

    @Override
    public Object fromString(String str) {
        return this.converter == null ? null : this.converter.fromString(str);
    }
}

