/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import repast.simphony.parameter.DefaultParameters;
import repast.simphony.parameter.IllegalParameterException;
import repast.simphony.parameter.Parameters;
import simphony.util.messages.MessageCenter;

public class BoundParameters
extends DefaultParameters {
    private Map<String, ObjectParameter> bindMap = new HashMap<String, ObjectParameter>();
    private Object bean;

    public BoundParameters(Parameters param) {
        super(param);
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
        for (String name : this.bindMap.keySet()) {
            ObjectParameter param = this.bindMap.get(name);
            if (param.isReadOnly()) continue;
            param.setValue(bean, super.getValue(name));
        }
    }

    @Override
    public void setValue(String paramName, Object val) {
        super.setValue(paramName, val);
        ObjectParameter param = this.bindMap.get(paramName);
        if (this.bean != null && param != null && !param.isReadOnly()) {
            param.setValue(this.bean, super.getValue(paramName));
        }
    }

    public void addParameter(String name, String displayName, Class<?> paramClass, Object val, Method readMethod, Method writeMethod) {
        this.addParameter(name, paramClass, val, readMethod, writeMethod);
        this.nameMap.put(name, displayName);
    }

    public void addParameter(String name, Class<?> paramClass, Object val, Method readMethod, Method writeMethod) {
        super.addParameter(name, paramClass, val, writeMethod == null);
        FastClass fastClass = FastClass.create(readMethod.getDeclaringClass());
        FastMethod fReadMethod = fastClass.getMethod(readMethod);
        FastMethod fWriteMethod = writeMethod == null ? null : fastClass.getMethod(writeMethod);
        this.bindMap.put(name, new ObjectParameter(fReadMethod, fWriteMethod));
    }

    static class ObjectParameter {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private FastMethod readMethod;
        private FastMethod writeMethod;

        public ObjectParameter(FastMethod readMethod, FastMethod writeMethod) {
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
        }

        public Object getValue(Object bean) {
            try {
                return this.readMethod.invoke(bean, EMPTY_ARRAY);
            }
            catch (InvocationTargetException e) {
                MessageCenter.getMessageCenter(this.getClass()).error((Object)"Unable to get feature attribute from object", (Throwable)e, new Object[0]);
                return Parameters.NULL;
            }
        }

        public void setValue(Object bean, Object value) throws IllegalParameterException {
            if (this.writeMethod == null) {
                throw new IllegalParameterException("Unable to set attribute: write method does not exist");
            }
            try {
                this.writeMethod.invoke(bean, new Object[]{value});
            }
            catch (InvocationTargetException e) {
                IllegalParameterException ex = new IllegalParameterException("Unable to set attribute: " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }

        public boolean isReadOnly() {
            return this.writeMethod == null;
        }
    }
}

