/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import repast.simphony.parameter.DefaultSchema;
import repast.simphony.parameter.IllegalParameterException;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.Schema;
import repast.simphony.util.collections.Pair;
import simphony.util.messages.MessageCenter;

public class BeanParameters
implements Parameters {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(BeanParameters.class);
    private Map<String, Parameter> parameters = new HashMap<String, Parameter>();
    private Object bean;
    private PropertyChangeSupport pcs;
    private Schema schema;

    public BeanParameters(Object bean) {
        this(bean, null);
    }

    public BeanParameters(Object bean, Set<String> paramNames) {
        try {
            this.bean = bean;
            BeanInfo info = Introspector.getBeanInfo(bean.getClass(), Object.class);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            ArrayList pairs = new ArrayList();
            int i = 0;
            while (i < pds.length) {
                PropertyDescriptor pd = pds[i];
                String name = pd.getName();
                if (paramNames == null || paramNames.contains(name)) {
                    FastClass fastClass = FastClass.create(bean.getClass());
                    FastMethod readMethod = fastClass.getMethod(pd.getReadMethod());
                    FastMethod writeMethod = pd.getWriteMethod() == null ? null : fastClass.getMethod(pd.getWriteMethod());
                    this.parameters.put(name, new ObjectParameter(readMethod, writeMethod));
                    pairs.add(new Pair(name, pd.getPropertyType()));
                }
                ++i;
            }
            this.schema = new DefaultSchema(pairs.toArray(new Pair[pairs.size()]));
        }
        catch (IntrospectionException e) {
            msgCenter.error((Object)"Unable to create feature attributes from agent", (Throwable)e, new Object[0]);
        }
        this.pcs = new PropertyChangeSupport(this);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Parameters clone() {
        try {
            return (Parameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public Object getValue(String paramName) {
        Parameter param = this.parameters.get(paramName);
        if (param != null) {
            return param.getValue(this.bean);
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not found");
    }

    @Override
    public String getValueAsString(String paramName) {
        return this.getValue(paramName).toString();
    }

    @Override
    public void setValue(String paramName, Object val) {
        Parameter param = this.parameters.get(paramName);
        if (param == null) {
            throw new IllegalParameterException("Parameter '" + paramName + "' not found");
        }
        Object oldVal = param.getValue(this.bean);
        param.setValue(this.bean, val);
        this.pcs.firePropertyChange(paramName, oldVal, val);
    }

    @Override
    public boolean isReadOnly(String paramName) {
        Parameter param = this.parameters.get(paramName);
        if (param != null) {
            return param.isReadOnly();
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not found");
    }

    public Object getBean() {
        return this.bean;
    }

    @Override
    public String getDisplayName(String paramName) {
        if (this.schema.contains(paramName)) {
            return paramName;
        }
        return null;
    }

    @Override
    public Double getDouble(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Double.class || paramType == Double.TYPE) {
            return (Double)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of double type.");
    }

    @Override
    public Integer getInteger(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Integer.class || paramType == Integer.TYPE) {
            return (Integer)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of integer type.");
    }

    @Override
    public Boolean getBoolean(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Boolean.class || paramType == Boolean.TYPE) {
            return (Boolean)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of boolean type.");
    }

    @Override
    public String getString(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == String.class) {
            return (String)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of String type.");
    }

    @Override
    public Long getLong(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Long.class || paramType == Long.TYPE) {
            return (Long)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of long type.");
    }

    @Override
    public Float getFloat(String paramName) {
        Object value = this.getValue(paramName);
        Class paramType = this.schema.getDetails(paramName).getType();
        if (paramType == Float.class || paramType == Float.TYPE) {
            return (Float)value;
        }
        throw new IllegalParameterException("Parameter '" + paramName + "' not of float type.");
    }

    static class ObjectParameter
    implements Parameter {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private FastMethod readMethod;
        private FastMethod writeMethod;

        public ObjectParameter(FastMethod readMethod, FastMethod writeMethod) {
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
        }

        @Override
        public Object getValue(Object bean) {
            try {
                return this.readMethod.invoke(bean, EMPTY_ARRAY);
            }
            catch (InvocationTargetException e) {
                MessageCenter.getMessageCenter(this.getClass()).error((Object)"Unable to get feature attribute from object", (Throwable)e, new Object[0]);
                return Parameters.NULL;
            }
        }

        @Override
        public void setValue(Object bean, Object value) throws IllegalParameterException {
            if (this.writeMethod == null) {
                throw new IllegalParameterException("Unable to set attribute: write method does not exist");
            }
            try {
                this.writeMethod.invoke(bean, new Object[]{value});
            }
            catch (InvocationTargetException e) {
                IllegalParameterException ex = new IllegalParameterException("Unable to set attribute: " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }

        @Override
        public boolean isReadOnly() {
            return this.writeMethod == null;
        }
    }

    static interface Parameter {
        public Object getValue(Object var1);

        public void setValue(Object var1, Object var2) throws IllegalParameterException;

        public boolean isReadOnly();
    }
}

