/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.freezedryers.proj;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.engine.environment.ProjectionRegistry;
import repast.simphony.engine.environment.ProjectionRegistryData;
import repast.simphony.freezedry.freezedryers.proj.ContinuousProjectionDryer;
import repast.simphony.freezedry.freezedryers.proj.GridProjectionDryer2;
import repast.simphony.freezedry.freezedryers.proj.NetworkProjectionDryer;
import repast.simphony.space.projection.Projection;

public abstract class ProjectionDryer<T extends Projection> {
    public static final String NAME_KEY = "name";
    public static final String PROJ_LISTENING_KEY = "projectionListening";
    public static final String CONTEXT_LISTENING_KEY = "contextListening";
    private static LinkedList<ProjectionDryer> projectionDryers;

    static {
        ProjectionDryer.addProjectionDryer(new NetworkProjectionDryer());
        ProjectionDryer.addProjectionDryer(new ContinuousProjectionDryer());
        ProjectionDryer.addProjectionDryer(new GridProjectionDryer2());
    }

    protected abstract void addProperties(Context<?> var1, T var2, Map<String, Object> var3);

    protected abstract T instantiate(Context<?> var1, Map<String, Object> var2);

    public abstract boolean handles(Class<?> var1);

    protected void loadProperties(Context<?> context, T proj, Map<String, Object> properties) {
        context.addProjection((Projection<?>)proj);
    }

    public Map<String, Object> getProperties(Context<?> context, T t) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put(NAME_KEY, t.getName());
        map.put(PROJ_LISTENING_KEY, context.getContextListeners().contains(t));
        map.put(CONTEXT_LISTENING_KEY, t.getProjectionListeners().contains(context));
        this.addProperties(context, t, map);
        return map;
    }

    public T buildAndAddProjection(Context<?> context, Map<String, Object> properties) {
        T t = this.instantiate(context, properties);
        this.loadProperties(context, t, properties);
        return t;
    }

    public static void addProjectionDryer(ProjectionDryer dryer) {
        if (projectionDryers == null) {
            projectionDryers = new LinkedList();
        }
        projectionDryers.addFirst(dryer);
    }

    public static <T extends Projection> ProjectionDryer<T> getDryer(Class<T> type) {
        if (projectionDryers == null) {
            return null;
        }
        for (ProjectionDryer dryer : projectionDryers) {
            if (!dryer.handles(type)) continue;
            return dryer;
        }
        for (ProjectionRegistryData registryData : ProjectionRegistry.getRegistryData()) {
            ProjectionDryer dryer = registryData.getProjectionDryer();
            if (!dryer.handles(type)) continue;
            return dryer;
        }
        return null;
    }
}

