/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.freezedryers.proj;

import java.util.ArrayList;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.context.space.graph.ContextJungNetwork;
import repast.simphony.freezedry.freezedryers.proj.ProjectionDryer;
import repast.simphony.space.graph.DirectedJungNetwork;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.graph.UndirectedJungNetwork;
import simphony.util.messages.MessageCenter;

public class NetworkProjectionDryer
extends ProjectionDryer<Network<?>> {
    public static final String DIRECTED_KEY = "directed";
    public static final String EDGES_KEY = "edges";
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(NetworkProjectionDryer.class);

    @Override
    protected void addProperties(Context<?> context, Network<?> net, Map<String, Object> map) {
        map.put(DIRECTED_KEY, net.isDirected());
        ArrayList<Object[]> edges = new ArrayList<Object[]>();
        for (RepastEdge<?> edge : net.getEdges()) {
            edges.add(this.getEdgeProps(edge));
        }
        map.put(EDGES_KEY, edges.toArray());
    }

    protected Object[] getEdgeProps(RepastEdge edge) {
        Object[] edgeProps = new Object[]{edge.getSource(), edge.getTarget(), edge.getWeight()};
        return edgeProps;
    }

    @Override
    public Network<?> instantiate(Context<?> context, Map<String, Object> properties) {
        ContextJungNetwork net = (Boolean)properties.get(DIRECTED_KEY) != false ? new ContextJungNetwork(new DirectedJungNetwork(properties.get("name").toString()), context) : new ContextJungNetwork(new UndirectedJungNetwork(properties.get("name").toString()), context);
        return net;
    }

    @Override
    protected void loadProperties(Context<?> context, Network<?> proj, Map<String, Object> properties) {
        super.loadProperties(context, proj, properties);
        Object[] edges = (Object[])properties.get(EDGES_KEY);
        if (edges == null) {
            LOG.info((Object)("The list of edges for context '" + context + "' resolved to null, not adding any edges"), new Object[0]);
            return;
        }
        this.loadEdges(edges, proj);
    }

    protected void loadEdges(Object[] edges, Network proj) {
        Object[] objectArray = edges;
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Object[]) {
                Object[] edgeProps = (Object[])o;
                proj.addEdge(edgeProps[0], edgeProps[1], (Double)edgeProps[2]);
            } else {
                LOG.warn((Object)("Edge properties '" + o + "' did not resolve to an Object[], edge skipped."), new Object[0]);
            }
            ++n2;
        }
    }

    @Override
    public boolean handles(Class<?> type) {
        return Network.class.isAssignableFrom(type);
    }
}

