/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.freezedryers.proj;

import java.util.HashMap;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.context.space.grid.ContextGrid;
import repast.simphony.freezedry.freezedryers.proj.ProjectionDryer;
import repast.simphony.space.grid.DefaultGrid;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.grid.RandomGridAdder;
import repast.simphony.space.grid.SingleOccupancyCellAccessor;
import repast.simphony.space.grid.StrictBorders;
import simphony.util.messages.MessageCenter;

public class GridProjectionDryer2
extends ProjectionDryer<Grid<?>> {
    public static final String TRANSLATOR_KEY = "translator";
    public static final String ADDER_KEY = "adder";
    public static final String CELL_ACCESSOR_KEY = "CELL_ACCESSOR";
    public static final String AGENT_LOCATIONS_KEY = "agentLocations";
    public static final String SPACE_DIMENSIONS_KEY = "spaceDimensions";
    public static final String SPACE_ORIGIN_KEY = "spaceOrigin";
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(GridProjectionDryer2.class);

    @Override
    protected void addProperties(Context<?> context, Grid<?> t, Map<String, Object> map) {
        HashMap agentLocs = new HashMap();
        for (Object o : t.getObjects()) {
            int[] loc = new int[t.getDimensions().size()];
            t.getLocation(o).toIntArray(loc);
            agentLocs.put(o, loc);
        }
        map.put(AGENT_LOCATIONS_KEY, agentLocs);
        int[] dimensions = new int[t.getDimensions().size()];
        t.getDimensions().toIntArray(dimensions);
        map.put(SPACE_DIMENSIONS_KEY, dimensions);
        int[] origin = new int[t.getDimensions().size()];
        t.getDimensions().originToIntArray(origin);
        map.put(SPACE_ORIGIN_KEY, dimensions);
        map.put(ADDER_KEY, t.getAdder());
        map.put(TRANSLATOR_KEY, t.getGridPointTranslator());
        map.put(CELL_ACCESSOR_KEY, t.getCellAccessor());
    }

    @Override
    protected void loadProperties(Context<?> context, Grid<?> proj, Map<String, Object> properties) {
        super.loadProperties(context, proj, properties);
        this.loadAgents(context, proj, properties);
    }

    protected void loadAgents(Context<?> context, Grid proj, Map<String, Object> properties) {
        HashMap locations = (HashMap)properties.get(AGENT_LOCATIONS_KEY);
        if (locations == null) {
            LOG.info((Object)("Could not find any locations for context '" + context + "'."), new Object[0]);
        }
        for (Object o : locations.keySet()) {
            if (locations.get(o) instanceof int[]) {
                int[] loc = (int[])locations.get(o);
                proj.moveTo(o, loc);
                continue;
            }
            LOG.warn((Object)("Object '" + o + "'s location did not resolve to a double, the object will not be placed on the space."), new Object[0]);
        }
    }

    @Override
    protected DefaultGrid<?> instantiate(Context<?> context, Map<String, Object> properties) {
        SingleOccupancyCellAccessor accessor;
        GridPointTranslator translator;
        int[] dimensions = (int[])properties.get(SPACE_DIMENSIONS_KEY);
        if (dimensions == null) {
            LOG.warn((Object)("Space's dimensions resolved to null for context '" + context + "', returning null"), new Object[0]);
            return null;
        }
        int[] origin = (int[])properties.get(SPACE_ORIGIN_KEY);
        if (origin == null) {
            LOG.warn((Object)("Space's origin resolved to null for context '" + context + "', returning null"), new Object[0]);
            return null;
        }
        String name = (String)properties.get("name");
        RandomGridAdder adder = (RandomGridAdder)properties.get(ADDER_KEY);
        if (adder == null) {
            LOG.info((Object)("Space's adder resolved to null for context '" + context + "', using default random adder"), new Object[0]);
            adder = new RandomGridAdder();
        }
        if ((translator = (GridPointTranslator)properties.get(TRANSLATOR_KEY)) == null) {
            LOG.info((Object)("Space's translator resolved to null for context '" + context + "' using default strict borders"), new Object[0]);
            translator = new StrictBorders();
        }
        if ((accessor = (SingleOccupancyCellAccessor)properties.get(CELL_ACCESSOR_KEY)) == null) {
            LOG.info((Object)("Space's cell accessor resolved to null for context '" + context + "', using default single occupancy accessor"), new Object[0]);
            accessor = new SingleOccupancyCellAccessor();
        }
        translator.init(new GridDimensions(dimensions, origin));
        ContextGrid grid = new ContextGrid(name, adder, translator, accessor, dimensions, origin);
        return grid;
    }

    @Override
    public boolean handles(Class<?> type) {
        return Grid.class.isAssignableFrom(type);
    }
}

