/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.freezedryers.proj;

import java.util.HashMap;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.context.space.continuous.ContextSpace;
import repast.simphony.freezedry.freezedryers.proj.ProjectionDryer;
import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.PointTranslator;
import repast.simphony.space.continuous.RandomCartesianAdder;
import repast.simphony.space.continuous.StickyBorders;
import simphony.util.messages.MessageCenter;

public class ContinuousProjectionDryer
extends ProjectionDryer<ContinuousSpace<?>> {
    public static final String TRANSLATOR_KEY = "translator";
    public static final String ADDER_KEY = "adder";
    public static final String AGENT_LOCATIONS_KEY = "agentLocations";
    public static final String SPACE_DIMENSIONS_KEY = "spaceDimensions";
    public static final String SPACE_ORIGIN_KEY = "spaceOrigin";
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(ContinuousProjectionDryer.class);

    @Override
    protected void addProperties(Context<?> context, ContinuousSpace<?> t, Map<String, Object> map) {
        HashMap agentLocs = new HashMap();
        for (Object o : t.getObjects()) {
            double[] loc = new double[t.getDimensions().size()];
            t.getLocation(o).toDoubleArray(loc);
            agentLocs.put(o, loc);
        }
        map.put(AGENT_LOCATIONS_KEY, agentLocs);
        double[] dimensions = new double[t.getDimensions().size()];
        t.getDimensions().toDoubleArray(dimensions);
        map.put(SPACE_DIMENSIONS_KEY, dimensions);
        double[] origin = new double[t.getDimensions().size()];
        t.getDimensions().originToDoubleArray(origin);
        map.put(SPACE_ORIGIN_KEY, origin);
        map.put(ADDER_KEY, t.getAdder());
        map.put(TRANSLATOR_KEY, t.getPointTranslator());
    }

    @Override
    protected void loadProperties(Context<?> context, ContinuousSpace<?> proj, Map<String, Object> properties) {
        super.loadProperties(context, proj, properties);
        this.loadAgents(context, proj, properties);
    }

    protected void loadAgents(Context<?> context, ContinuousSpace proj, Map<String, Object> properties) {
        HashMap locations = (HashMap)properties.get(AGENT_LOCATIONS_KEY);
        if (locations == null) {
            LOG.info((Object)("Could not find any locations for context '" + context + "'."), new Object[0]);
        }
        for (Object o : locations.keySet()) {
            if (locations.get(o) instanceof double[]) {
                double[] loc = (double[])locations.get(o);
                proj.moveTo(o, loc);
                continue;
            }
            LOG.warn((Object)("Object '" + o + "'s location did not resolve to a double, the object will not be placed on the space."), new Object[0]);
        }
    }

    @Override
    protected ContinuousSpace<?> instantiate(Context<?> context, Map<String, Object> properties) {
        PointTranslator translator;
        double[] dimensions = (double[])properties.get(SPACE_DIMENSIONS_KEY);
        if (dimensions == null) {
            LOG.warn((Object)("Space's dimensions resolved to null for context '" + context + "', returning null"), new Object[0]);
            return null;
        }
        double[] origin = (double[])properties.get(SPACE_ORIGIN_KEY);
        if (origin == null) {
            LOG.warn((Object)("Space's origin resolved to null for context '" + context + "', returning null"), new Object[0]);
            return null;
        }
        String name = (String)properties.get("name");
        RandomCartesianAdder adder = (RandomCartesianAdder)properties.get(ADDER_KEY);
        if (adder == null) {
            LOG.info((Object)("Space's adder resolved to null for context '" + context + "', using default random adder"), new Object[0]);
            adder = new RandomCartesianAdder();
        }
        if ((translator = (PointTranslator)properties.get(TRANSLATOR_KEY)) == null) {
            LOG.info((Object)("Space's translator resolved to null for context '" + context + "', using default sticky borders"), new Object[0]);
            translator = new StickyBorders();
        }
        translator.init(new Dimensions(dimensions, origin));
        ContextSpace space = new ContextSpace(name, adder, translator, dimensions, origin);
        return space;
    }

    @Override
    public boolean handles(Class<?> type) {
        return ContinuousSpace.class.isAssignableFrom(type);
    }
}

