/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.freezedryers;

import repast.simphony.freezedry.FieldUtilities;
import repast.simphony.freezedry.FreezeDryedObject;
import repast.simphony.freezedry.FreezeDryer;
import repast.simphony.freezedry.FreezeDryingException;

public class PrimitiveFreezeDryer
implements FreezeDryer {
    public static final String TYPE_COL = "TYPE";
    public static final String VAL_COL = "VAL";

    public FreezeDryedObject freezeDry(String id, Object o) throws FreezeDryingException {
        if (!FieldUtilities.INSTANCE.isPrimitive(o.getClass().getName())) {
            throw new FreezeDryingException("Object '" + o + "'is not a primitive");
        }
        FreezeDryedObject obj = new FreezeDryedObject(id, o.getClass());
        String strVal = o.toString();
        if (o instanceof Boolean) {
            strVal = strVal.toUpperCase();
        }
        obj.put(VAL_COL, strVal);
        return obj;
    }

    public Object rehydrate(FreezeDryedObject fdo) throws FreezeDryingException {
        PrimitiveConverter converter = PrimitiveConverter.getConverter(fdo.getType().getName());
        if (converter != null) {
            return converter.convert(fdo.get(VAL_COL).toString());
        }
        return null;
    }

    public boolean handles(Class clazz) {
        return PrimitiveConverter.getConverter(clazz.getName()) != null;
    }

    static enum PrimitiveConverter {
        DOUBLE((Class)Double.class, (Class)Double.TYPE){

            @Override
            public Object convert(String val) {
                return Double.valueOf(val);
            }
        }
        ,
        FLOAT((Class)Float.class, (Class)Float.TYPE){

            @Override
            public Object convert(String val) {
                return Integer.valueOf(val);
            }
        }
        ,
        INTEGER((Class)Integer.class, (Class)Integer.TYPE){

            @Override
            public Object convert(String val) {
                return Integer.valueOf(val);
            }
        }
        ,
        SHORT((Class)Short.class, (Class)Short.TYPE){

            @Override
            public Object convert(String val) {
                return Short.valueOf(val);
            }
        }
        ,
        BYTE((Class)Byte.class, (Class)Byte.TYPE){

            @Override
            public Object convert(String val) {
                return Byte.valueOf(val);
            }
        }
        ,
        LONG((Class)Long.class, (Class)Long.TYPE){

            @Override
            public Object convert(String val) {
                return Long.valueOf(val);
            }
        }
        ,
        BOOLEAN((Class)Boolean.class, (Class)Boolean.TYPE){

            @Override
            public Object convert(String val) {
                return Boolean.valueOf(val);
            }
        }
        ,
        STRING((Class)String.class, null){

            @Override
            public Object convert(String val) {
                return val;
            }
        }
        ,
        CHARACTER((Class)Character.class, (Class)Character.TYPE){

            @Override
            public Object convert(String val) {
                if (val.length() != 1) {
                    return null;
                }
                return Character.valueOf(val.charAt(0));
            }
        };

        String className;
        String typeName;

        private PrimitiveConverter(Class<?> clazz, Class<?> type) {
            this.className = clazz.getName();
            this.typeName = type == null ? null : type.getName();
        }

        public abstract Object convert(String var1);

        public static PrimitiveConverter getConverter(String name) {
            PrimitiveConverter[] primitiveConverterArray = PrimitiveConverter.values();
            int n = primitiveConverterArray.length;
            int n2 = 0;
            while (n2 < n) {
                PrimitiveConverter converter = primitiveConverterArray[n2];
                if (converter.className.equals(name) || converter.typeName != null && converter.typeName.equals(name)) {
                    return converter;
                }
                ++n2;
            }
            return null;
        }
    }
}

